/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.grid.EnergyNetwork;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalConductor;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileEntityAluminumWireSwitch
extends TileBaseUniversalConductor {
    public int tier;
    private boolean disableConnections;

    public TileEntityAluminumWireSwitch() {
        this(1);
    }

    public TileEntityAluminumWireSwitch(int theTier) {
        this.tier = theTier;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tier = nbt.func_74762_e("tier");
        if (this.tier == 0) {
            this.tier = 1;
        }
        this.disableConnections = this.disableConnections();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("tier", this.tier);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public int getTierGC() {
        return this.tier;
    }

    @Override
    public void refresh() {
        boolean newDisableConnections = this.disableConnections();
        if (newDisableConnections && !this.disableConnections) {
            this.disableConnections = newDisableConnections;
            if (!this.field_145850_b.field_72995_K) {
                this.disConnect();
            }
        } else if (!newDisableConnections && this.disableConnections) {
            this.disableConnections = newDisableConnections;
            if (!this.field_145850_b.field_72995_K) {
                this.setNetwork(null);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.adjacentConnections = null;
            if (!this.disableConnections) {
                this.getNetwork().refresh();
                BlockVec3 thisVec = new BlockVec3(this);
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    TileEntity tileEntity;
                    if (!this.canConnect(side, NetworkType.POWER) || !((tileEntity = thisVec.getTileEntityOnSide(this.field_145850_b, side)) instanceof TileBaseConductor) || !((TileBaseConductor)tileEntity).canConnect(side.func_176734_d(), NetworkType.POWER)) continue;
                    IGridNetwork otherNet = ((INetworkProvider)tileEntity).getNetwork();
                    if (this.getNetwork().equals(otherNet) || otherNet.getTransmitters().isEmpty()) continue;
                    otherNet.merge(this.getNetwork());
                }
            }
        }
    }

    private void disConnect() {
        EnergyNetwork net = (EnergyNetwork)this.getNetwork();
        if (net != null) {
            net.split(this);
        }
    }

    private boolean disableConnections() {
        return RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public boolean canConnect(EnumFacing direction, NetworkType type) {
        return type == NetworkType.POWER && !this.disableConnections();
    }

    @Override
    public IElectricityNetwork getNetwork() {
        if (this.network == null) {
            EnergyNetwork network = new EnergyNetwork();
            if (!this.disableConnections) {
                network.getTransmitters().add(this);
            }
            this.setNetwork(network);
        }
        return (IElectricityNetwork)this.network;
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = new TileEntity[6];
            if (!this.disableConnections) {
                BlockVec3 thisVec = new BlockVec3(this);
                for (int i = 0; i < 6; ++i) {
                    TileEntity tileEntity;
                    EnumFacing side = EnumFacing.func_82600_a((int)i);
                    if (!this.canConnect(side, NetworkType.POWER) || !((tileEntity = thisVec.getTileEntityOnSide(this.field_145850_b, side)) instanceof IConnector) || !((IConnector)tileEntity).canConnect(side.func_176734_d(), NetworkType.POWER)) continue;
                    this.adjacentConnections[i] = tileEntity;
                }
            }
        }
        return this.adjacentConnections;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.disableConnections() ? false : super.acceptsEnergyFrom(emitter, side);
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return this.disableConnections ? amount : super.injectEnergy(directionFrom, amount, voltage);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.disableConnections() ? false : super.emitsEnergyTo(receiver, side);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.disableConnections ? 0 : super.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.disableConnections() ? false : super.canConnectEnergy(from);
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return this.disableConnections() ? false : super.canReceiveEnergy(side);
    }
}

