/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMachineBase
extends BlockTileGC
implements IShiftDescription,
ISortableBlock {
    public static final int METADATA_MASK = 12;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected EnumMachineBase[] types;
    protected EnumMachineBase typeBase;

    public BlockMachineBase(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
        this.initialiseTypes();
    }

    protected abstract void initialiseTypes();

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int metadata = this.func_176201_c(state);
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        worldIn.func_180501_a(pos, this.func_176203_a((metadata & 0xC) + change), 3);
    }

    @Override
    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public boolean onSneakUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IMachineSides) {
            ((IMachineSides)tile).nextSideConfiguration(tile);
            return true;
        }
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = this.func_176201_c(state);
        EnumMachineBase type = this.typeBase.fromMetadata(meta);
        return type.tileConstructor();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) & 0xC;
    }

    public String getUnlocalizedName(int meta) {
        EnumMachineBase type = this.typeBase.fromMetadata(meta);
        return type.getUnlocalizedName();
    }

    @Override
    public String getShiftDescription(int meta) {
        EnumMachineBase type = this.typeBase.fromMetadata(meta);
        return GCCoreUtil.translate(type.getShiftDescriptionKey());
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public static EnumFacing getFront(IBlockState state) {
        if (state.func_177230_c() instanceof BlockMachineBase) {
            return (EnumFacing)state.func_177229_b((IProperty)FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumMachineBase type : this.types) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public static interface EnumMachineBase<T extends Enum<T>> {
        public int getMetadata();

        public EnumMachineBase fromMetadata(int var1);

        public String getShiftDescriptionKey();

        public String getUnlocalizedName();

        public TileEntity tileConstructor();
    }
}

