/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.widget;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.item.filtering.IItemFilter;
import codechicken.lib.item.filtering.IItemFilterProvider;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.API;
import codechicken.nei.config.KeyBindings;
import codechicken.nei.jei.EnumItemBrowser;
import codechicken.nei.jei.JEIIntegrationManager;
import codechicken.nei.util.ItemList;
import codechicken.nei.widget.ItemPanel;
import codechicken.nei.widget.TextField;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.util.text.TextFormatting;

public class SearchField
extends TextField
implements IItemFilterProvider {
    public static List<ISearchProvider> searchProviders = new LinkedList<ISearchProvider>();
    long lastclicktime;

    public SearchField(String ident) {
        super(ident);
        API.addItemFilter(this);
        API.addSearchProvider(new DefaultSearchProvider());
    }

    public static boolean searchInventories() {
        return NEIClientConfig.world.nbt.func_74767_n("searchinventories");
    }

    @Override
    public int getTextColour() {
        if (JEIIntegrationManager.itemPanelOwner == EnumItemBrowser.JEI ? JEIIntegrationManager.getFilteredItems().size() == 0 : ItemPanel.items.size() == 0) {
            return Color.red.getRGB();
        }
        return super.getTextColour();
    }

    @Override
    public void drawBox() {
        if (SearchField.searchInventories()) {
            GuiDraw.drawGradientRect((int)this.x, (int)this.y, (int)this.w, (int)this.h, (int)-256, (int)-4149248);
        } else {
            GuiDraw.drawRect((int)this.x, (int)this.y, (int)this.w, (int)this.h, (int)-6250336);
        }
        GuiDraw.drawRect((int)(this.x + 1), (int)(this.y + 1), (int)(this.w - 2), (int)(this.h - 2), (int)-16777216);
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (button == 0) {
            if (this.focused() && System.currentTimeMillis() - this.lastclicktime < 500L) {
                NEIClientConfig.world.nbt.func_74757_a("searchinventories", !SearchField.searchInventories());
                NEIClientConfig.world.saveNBT();
            } else {
                this.lastclicktime = System.currentTimeMillis();
            }
        }
        return super.handleClick(mousex, mousey, button);
    }

    @Override
    public void onTextChange(String oldText) {
        NEIClientConfig.setSearchExpression(this.text());
        ItemList.updateFilter.restart();
    }

    @Override
    public void lastKeyTyped(int keyID, char keyChar) {
        if (KeyBindings.get("nei.options.keys.gui.search").isActiveAndMatches(keyID)) {
            this.setFocus(true);
        }
    }

    @Override
    public String filterText(String s) {
        return TextFormatting.func_110646_a((String)s);
    }

    public static Pattern getPattern(String search) {
        switch (NEIClientConfig.getIntSetting("inventory.searchmode")) {
            case 0: {
                search = "\\Q" + search + "\\E";
                break;
            }
            case 1: {
                search = search.replace(".", "").replace("?", ".").replace("*", ".+?");
            }
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(search);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return pattern == null || pattern.toString().length() == 0 ? null : pattern;
    }

    public IItemFilter getFilter() {
        String s_filter = this.text().toLowerCase();
        LinkedList<IItemFilter> primary = new LinkedList<IItemFilter>();
        LinkedList<IItemFilter> secondary = new LinkedList<IItemFilter>();
        for (ISearchProvider p : searchProviders) {
            IItemFilter filter = p.getFilter(s_filter);
            if (filter == null) continue;
            (p.isPrimary() ? primary : secondary).add(filter);
        }
        if (!primary.isEmpty()) {
            return new ItemList.AnyMultiItemFilter(primary);
        }
        if (!secondary.isEmpty()) {
            return new ItemList.AnyMultiItemFilter(secondary);
        }
        return new ItemList.EverythingItemFilter();
    }

    private static class DefaultSearchProvider
    implements ISearchProvider {
        private DefaultSearchProvider() {
        }

        @Override
        public boolean isPrimary() {
            return false;
        }

        @Override
        public IItemFilter getFilter(String searchText) {
            Pattern pattern = SearchField.getPattern(searchText);
            return pattern == null ? null : new ItemList.PatternItemFilter(pattern);
        }
    }

    public static interface ISearchProvider {
        public boolean isPrimary();

        public IItemFilter getFilter(String var1);
    }
}

