/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.integration.nbt;

import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.dave.ocsensors.integration.AbstractIntegration;
import org.dave.ocsensors.integration.Integrate;
import org.dave.ocsensors.integration.PrefixRegistry;
import org.dave.ocsensors.integration.ScanDataList;
import org.dave.ocsensors.integration.nbt.NbtConfig;
import org.dave.ocsensors.misc.ConfigurationHandler;
import org.dave.ocsensors.utility.Logz;
import org.dave.ocsensors.utility.ResourceLoader;
import org.dave.ocsensors.utility.Serialization;

@Integrate(name="nbt")
public class NbtIntegration
extends AbstractIntegration {
    private static Pattern pathRegex = Pattern.compile("(.*?)\\[(.*?)\\]");
    private static Map<Class, Map<String, String>> mappings;

    @Override
    public void reload() {
        mappings = new HashMap<Class, Map<String, String>>();
        PrefixRegistry.clearSupportedPrefixes(NbtIntegration.class);
        if (!ConfigurationHandler.nbtDataDir.exists()) {
            return;
        }
        ResourceLoader loader = new ResourceLoader(ConfigurationHandler.nbtDataDir, "assets/ocsensors/config/nbt/");
        for (Map.Entry<String, InputStream> entry : loader.getResources().entrySet()) {
            String filename = entry.getKey();
            InputStream is = entry.getValue();
            Logz.info(" > Loading nbt config from file: '%s'", filename);
            Serialization.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(is)), NbtConfig.class);
        }
    }

    public static void addMapping(Class clazz, String propertyPath, String fieldPath) {
        if (!mappings.containsKey(clazz)) {
            mappings.put(clazz, new HashMap());
        }
        mappings.get(clazz).put(propertyPath, fieldPath);
    }

    @Override
    public boolean worksWith(Entity entity) {
        for (Class clazz : mappings.keySet()) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean worksWith(TileEntity entity, @Nullable EnumFacing side) {
        for (Class clazz : mappings.keySet()) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addScanData(ScanDataList data, Entity entity) {
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_189511_e(tag);
        for (Map.Entry<Class, Map<String, String>> entry : mappings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(entity.getClass())) continue;
            for (Map.Entry<String, String> rule : entry.getValue().entrySet()) {
                String propertyPath = rule.getKey();
                String fieldPath = rule.getValue();
                Object value = NbtIntegration.recurseNbtTag(tag, fieldPath);
                if (value == null) continue;
                data.add(propertyPath, value);
            }
        }
    }

    @Override
    public void addScanData(ScanDataList data, TileEntity entity, @Nullable EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_189515_b(tag);
        for (Map.Entry<Class, Map<String, String>> entry : mappings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(entity.getClass())) continue;
            for (Map.Entry<String, String> rule : entry.getValue().entrySet()) {
                String propertyPath = rule.getKey();
                String fieldPath = rule.getValue();
                Object value = NbtIntegration.recurseNbtTag(tag, fieldPath);
                if (value == null) continue;
                data.add(propertyPath, value);
            }
        }
    }

    private static Object recurseNbtTag(NBTTagCompound pointer, String path) {
        List<String> parts = Arrays.asList(path.split("/"));
        String entry = parts.get(0);
        Matcher matcher = pathRegex.matcher(entry);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String key = matcher.group(2);
            if (!pointer.func_74764_b(key)) {
                return null;
            }
            if (type.equalsIgnoreCase("string")) {
                return pointer.func_74779_i(key);
            }
            if (type.equalsIgnoreCase("short")) {
                return pointer.func_74765_d(key);
            }
            if (type.equalsIgnoreCase("int")) {
                return pointer.func_74762_e(key);
            }
            Logz.warn("Unsupported nbt type: %s", type);
            return null;
        }
        if (parts.size() > 1) {
            String remaining = String.join((CharSequence)"/", parts.subList(1, parts.size()));
            return NbtIntegration.recurseNbtTag(pointer.func_74775_l(entry), remaining);
        }
        return null;
    }
}

