/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.base;

import java.util.List;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.dave.ocsensors.base.TileEntityBase;

public abstract class TileEntitySidedEnvironmentBase
extends TileEntityBase
implements SidedEnvironment,
Environment {
    protected Node node = null;
    private List<EnumFacing> invalidSides = null;

    public TileEntitySidedEnvironmentBase(String componentName, List<EnumFacing> invalidSides) {
        this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(componentName).create();
        this.invalidSides = invalidSides;
    }

    @Override
    protected void initialize() {
        super.initialize();
        Network.joinOrCreateNetwork((TileEntity)this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        return nbt;
    }

    public Node sidedNode(EnumFacing side) {
        if (this.invalidSides.contains(side)) {
            return null;
        }
        return this.node;
    }

    public boolean canConnect(EnumFacing side) {
        return !this.invalidSides.contains(side);
    }

    public Node node() {
        return this.node;
    }

    public void onConnect(Node node) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
    }
}

