/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.ITickingMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class MEMonitorIFluidHandler
implements IMEMonitor<IAEFluidStack>,
ITickingMonitor {
    private final IFluidHandler handler;
    private final IItemList<IAEFluidStack> list = AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> listeners = new HashMap();
    private final NavigableMap<Integer, CachedFluidStack> memory;
    private IActionSource mySource;
    private StorageFilter mode = StorageFilter.EXTRACTABLE_ONLY;

    public MEMonitorIFluidHandler(IFluidHandler handler) {
        this.handler = handler;
        this.memory = new ConcurrentSkipListMap<Integer, CachedFluidStack>();
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEFluidStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEFluidStack> l) {
        this.listeners.remove(l);
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, IActionSource src) {
        int filled = this.handler.fill(input.getFluidStack(), type == Actionable.MODULATE);
        if (filled == 0) {
            return input.copy();
        }
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        if ((long)filled == input.getStackSize()) {
            return null;
        }
        IAEFluidStack o = input.copy();
        o.setStackSize(input.getStackSize() - (long)filled);
        return o;
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable type, IActionSource src) {
        FluidStack removed = this.handler.drain(request.getFluidStack(), type == Actionable.MODULATE);
        if (removed == null || removed.amount == 0) {
            return null;
        }
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        IAEFluidStack o = request.copy();
        o.setStackSize(removed.amount);
        return o;
    }

    @Override
    public IStorageChannel getChannel() {
        return AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public TickRateModulation onTick() {
        ArrayList<IAEFluidStack> changes = new ArrayList<IAEFluidStack>();
        this.list.resetStatus();
        int high = 0;
        boolean changed = false;
        IFluidTankProperties[] props = this.handler.getTankProperties();
        for (int slot = 0; slot < this.handler.getTankProperties().length; ++slot) {
            FluidStack oldIS;
            CachedFluidStack old = (CachedFluidStack)this.memory.get(slot);
            high = Math.max(high, slot);
            FluidStack newIS = !props[slot].canDrain() && this.getMode() == StorageFilter.EXTRACTABLE_ONLY ? null : props[slot].getContents();
            FluidStack fluidStack = oldIS = old == null ? null : old.fluidStack;
            if (MEMonitorIFluidHandler.isDifferent(newIS, oldIS)) {
                CachedFluidStack cis = new CachedFluidStack(newIS);
                this.memory.put(slot, cis);
                if (old != null && old.aeStack != null) {
                    old.aeStack.setStackSize(-old.aeStack.getStackSize());
                    changes.add(old.aeStack);
                }
                if (cis.aeStack != null) {
                    changes.add(cis.aeStack);
                    this.list.add(cis.aeStack);
                }
                changed = true;
                continue;
            }
            int newSize = newIS == null ? 0 : newIS.amount;
            int diff = newSize - (oldIS == null ? 0 : oldIS.amount);
            IAEStack stack = null;
            if (newIS != null) {
                IAEStack<IAEFluidStack> iAEStack = stack = old == null || old.aeStack == null ? (IAEFluidStack)AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class).createStack(newIS) : old.aeStack.copy();
            }
            if (stack != null) {
                stack.setStackSize(newSize);
                this.list.add((IAEFluidStack)stack);
            }
            if (diff == 0 || stack == null) continue;
            CachedFluidStack cis = new CachedFluidStack(newIS);
            this.memory.put(slot, cis);
            IAEFluidStack a = stack.copy();
            a.setStackSize(diff);
            changes.add(a);
            changed = true;
        }
        NavigableMap<Integer, CachedFluidStack> end = this.memory.tailMap(high, false);
        if (!end.isEmpty()) {
            for (CachedFluidStack cis : end.values()) {
                if (cis == null || cis.aeStack == null) continue;
                IAEFluidStack a = cis.aeStack.copy();
                a.setStackSize(-a.getStackSize());
                changes.add(a);
                changed = true;
            }
            end.clear();
        }
        if (!changes.isEmpty()) {
            this.postDifference(changes);
        }
        return changed ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    private static boolean isDifferent(FluidStack a, FluidStack b) {
        if (a == b) {
            return false;
        }
        if (a == null || b == null) {
            return true;
        }
        return !a.getFluid().equals(b.getFluid());
    }

    private void postDifference(Iterable<IAEFluidStack> a) {
        if (a != null) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEFluidStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange(this, a, this.getActionSource());
                    continue;
                }
                i.remove();
            }
        }
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEFluidStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEFluidStack input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList out) {
        for (CachedFluidStack is : this.memory.values()) {
            out.addStorage(is.aeStack);
        }
        return out;
    }

    @Override
    public IItemList<IAEFluidStack> getStorageList() {
        return this.list;
    }

    private StorageFilter getMode() {
        return this.mode;
    }

    public void setMode(StorageFilter mode) {
        this.mode = mode;
    }

    private IActionSource getActionSource() {
        return this.mySource;
    }

    @Override
    public void setActionSource(IActionSource mySource) {
        this.mySource = mySource;
    }

    private static class CachedFluidStack {
        private final FluidStack fluidStack;
        private final IAEFluidStack aeStack;

        CachedFluidStack(FluidStack is) {
            if (is == null) {
                this.fluidStack = null;
                this.aeStack = null;
            } else {
                this.fluidStack = is.copy();
                this.aeStack = (IAEFluidStack)AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class).createStack(is);
            }
        }
    }
}

