/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render.font;

import cofh.core.render.FontRendererCore;
import cofh.core.render.font.ICustomCharRenderer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderSprite
implements ICustomCharRenderer {
    public final char underlyingCharacter;
    private final ResourceLocation textureSheet;
    private final float u;
    private final float v;
    private final float w;
    private final float h;
    private final float sw;
    private final float rw;
    private final int bw;

    public RenderSprite(char underlyingCharacter, ResourceLocation textureSheet, float u, float v, float w, float h) {
        this.underlyingCharacter = underlyingCharacter;
        this.textureSheet = textureSheet;
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
        this.sw = w / h * 7.99f;
        this.rw = w / h * 8.02f;
        this.bw = (int)Math.ceil(w / h * 8.0f - 2.0E-4f);
    }

    @Override
    public float renderChar(char letter, boolean italicFlag, float x, float y, FontRendererCore fontRenderer) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        fontRenderer.bindTexture(this.textureSheet);
        float italicOffset = italicFlag ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(this.u / 256.0f), (float)(this.v / 256.0f));
        GL11.glVertex3f((float)(x + italicOffset), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)(this.u / 256.0f), (float)((this.v + this.h) / 256.0f));
        GL11.glVertex3f((float)(x - italicOffset), (float)(y + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((this.u + this.w) / 256.0f), (float)(this.v / 256.0f));
        GL11.glVertex3f((float)(x + this.sw + italicOffset), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)((this.u + this.w) / 256.0f), (float)((this.v + this.h) / 256.0f));
        GL11.glVertex3f((float)(x + this.sw - italicOffset), (float)(y + 7.99f), (float)0.0f);
        GL11.glEnd();
        fontRenderer.resetColor();
        return this.rw;
    }

    @Override
    public int getCharWidth(char letter, FontRendererCore fontRenderer) {
        return this.bw;
    }

    public static char addRenderer(char c, ResourceLocation texture, int u, int v, int w, int h, FontRendererCore fontRenderer) {
        RenderSprite renderSprite = new RenderSprite(c, texture, u, v, w, h);
        fontRenderer.renderOverrides.put(c, (Object)renderSprite);
        return c;
    }
}

