/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.planets.Ceres.spacestation.TeleportTypeCeresOrbit;
import com.mjr.extraplanets.planets.Ceres.spacestation.WorldProviderCeresOrbit;
import com.mjr.extraplanets.planets.Eris.spacestation.TeleportTypeErisOrbit;
import com.mjr.extraplanets.planets.Eris.spacestation.WorldProviderErisOrbit;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.Jupiter.spacestation.TeleportTypeJupiterOrbit;
import com.mjr.extraplanets.planets.Jupiter.spacestation.WorldProviderJupiterOrbit;
import com.mjr.extraplanets.planets.Kepler22b.spacestation.TeleportTypeKepler22bOrbit;
import com.mjr.extraplanets.planets.Kepler22b.spacestation.WorldProviderKepler22bOrbit;
import com.mjr.extraplanets.planets.Mercury.spacestation.TeleportTypeMercuryOrbit;
import com.mjr.extraplanets.planets.Mercury.spacestation.WorldProviderMercuryOrbit;
import com.mjr.extraplanets.planets.Neptune.spacestation.TeleportTypeNeptuneOrbit;
import com.mjr.extraplanets.planets.Neptune.spacestation.WorldProviderNeptuneOrbit;
import com.mjr.extraplanets.planets.Pluto.spacestation.TeleportTypePlutoOrbit;
import com.mjr.extraplanets.planets.Pluto.spacestation.WorldProviderPlutoOrbit;
import com.mjr.extraplanets.planets.Saturn.spacestation.TeleportTypeSaturnOrbit;
import com.mjr.extraplanets.planets.Saturn.spacestation.WorldProviderSaturnOrbit;
import com.mjr.extraplanets.planets.Uranus.spacestation.TeleportTypeUranusOrbit;
import com.mjr.extraplanets.planets.Uranus.spacestation.WorldProviderUranusOrbit;
import com.mjr.extraplanets.planets.mars.spacestation.TeleportTypeMarsOrbit;
import com.mjr.extraplanets.planets.mars.spacestation.WorldProviderMarsOrbit;
import com.mjr.extraplanets.planets.venus.spacestation.TeleportTypeVenusOrbit;
import com.mjr.extraplanets.planets.venus.spacestation.WorldProviderVenusOrbit;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeOrbit;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class ExtraPlanets_SpaceStations {
    public static Satellite MERCURY_SPACE_STATION;
    public static Satellite VENUS_SPACE_STATION;
    public static Satellite CERES_SPACE_STATION;
    public static Satellite MARS_SPACE_STATION;
    public static Satellite JUPITER_SPACE_STATION;
    public static Satellite SATURN_SPACE_STATION;
    public static Satellite URANUS_SPACE_STATION;
    public static Satellite NEPTUNE_SPACE_STATION;
    public static Satellite PLUTO_SPACE_STATION;
    public static Satellite ERIS_SPACE_STATION;
    public static Satellite KEPLER22B_SPACE_STATION;

    public static void init() {
        ExtraPlanets_SpaceStations.initializeSatellites();
        ExtraPlanets_SpaceStations.registerSatellites();
    }

    private static void initializeSatellites() {
        if (Config.MERCURY_SPACE_STATION && Config.MERCURY) {
            MERCURY_SPACE_STATION = new Satellite("space_station.mercury").setParentBody(ExtraPlanets_Planets.MERCURY);
            MERCURY_SPACE_STATION.setRelativeSize(0.2667f);
            MERCURY_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            MERCURY_SPACE_STATION.setRelativeOrbitTime(20.0f);
            MERCURY_SPACE_STATION.setTierRequired(ExtraPlanets_Planets.MERCURY.getTierRequirement());
            MERCURY_SPACE_STATION.setDimensionInfo(Config.MERCURY_SPACE_STATION_ID, Config.MERCURY_SPACE_STATION_STATIC_ID, WorldProviderMercuryOrbit.class);
            MERCURY_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            MERCURY_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            MERCURY_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.VENUS_SPACE_STATION) {
            VENUS_SPACE_STATION = new Satellite("space_station.venus").setParentBody(VenusModule.planetVenus);
            VENUS_SPACE_STATION.setRelativeSize(0.2667f);
            VENUS_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            VENUS_SPACE_STATION.setRelativeOrbitTime(20.0f);
            VENUS_SPACE_STATION.setTierRequired(VenusModule.planetVenus.getTierRequirement());
            VENUS_SPACE_STATION.setDimensionInfo(Config.VENUS_SPACE_STATION_ID, Config.VENUS_SPACE_STATION_STATIC_ID, WorldProviderVenusOrbit.class);
            VENUS_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            VENUS_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            VENUS_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.CERES_SPACE_STATION && Config.CERES) {
            CERES_SPACE_STATION = new Satellite("space_station.ceres").setParentBody(ExtraPlanets_Planets.CERES);
            CERES_SPACE_STATION.setRelativeSize(0.2667f);
            CERES_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            CERES_SPACE_STATION.setRelativeOrbitTime(20.0f);
            CERES_SPACE_STATION.setTierRequired(ExtraPlanets_Planets.CERES.getTierRequirement());
            CERES_SPACE_STATION.setDimensionInfo(Config.CERES_SPACE_STATION_ID, Config.CERES_SPACE_STATION_STATIC_ID, WorldProviderCeresOrbit.class);
            CERES_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            CERES_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            CERES_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.MARS_SPACE_STATION && MarsModule.planetMars != null) {
            MARS_SPACE_STATION = new Satellite("space_station.mars").setParentBody(MarsModule.planetMars);
            MARS_SPACE_STATION.setRelativeSize(0.2667f);
            MARS_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            MARS_SPACE_STATION.setRelativeOrbitTime(20.0f);
            MARS_SPACE_STATION.setTierRequired(MarsModule.planetMars.getTierRequirement());
            MARS_SPACE_STATION.setDimensionInfo(Config.MARS_SPACE_STATION_ID, Config.MARS_SPACE_STATION_STATIC_ID, WorldProviderMarsOrbit.class);
            MARS_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            MARS_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            MARS_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.JUPITER_SPACE_STATION && Config.JUPITER) {
            JUPITER_SPACE_STATION = new Satellite("space_station.jupiter").setParentBody(ExtraPlanets_Planets.JUPITER);
            JUPITER_SPACE_STATION.setRelativeSize(0.2667f);
            JUPITER_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            JUPITER_SPACE_STATION.setRelativeOrbitTime(20.0f);
            JUPITER_SPACE_STATION.setTierRequired(ExtraPlanets_Planets.JUPITER.getTierRequirement());
            JUPITER_SPACE_STATION.setDimensionInfo(Config.JUPITER_SPACE_STATION_ID, Config.JUPITER_SPACE_STATION_STATIC_ID, WorldProviderJupiterOrbit.class);
            JUPITER_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            JUPITER_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            JUPITER_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.SATURN_SPACE_STATION && Config.SATURN) {
            SATURN_SPACE_STATION = new Satellite("space_station.saturn").setParentBody(ExtraPlanets_Planets.SATURN);
            SATURN_SPACE_STATION.setRelativeSize(0.2667f);
            SATURN_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            SATURN_SPACE_STATION.setRelativeOrbitTime(20.0f);
            SATURN_SPACE_STATION.setTierRequired(ExtraPlanets_Planets.SATURN.getTierRequirement());
            SATURN_SPACE_STATION.setDimensionInfo(Config.SATURN_SPACE_STATION_ID, Config.SATURN_SPACE_STATION_STATIC_ID, WorldProviderSaturnOrbit.class);
            SATURN_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            SATURN_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            SATURN_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.URANUS_SPACE_STATION && Config.URANUS) {
            URANUS_SPACE_STATION = new Satellite("space_station.uranus").setParentBody(ExtraPlanets_Planets.URANUS);
            URANUS_SPACE_STATION.setRelativeSize(0.2667f);
            URANUS_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            URANUS_SPACE_STATION.setRelativeOrbitTime(20.0f);
            URANUS_SPACE_STATION.setTierRequired(ExtraPlanets_Planets.URANUS.getTierRequirement());
            URANUS_SPACE_STATION.setDimensionInfo(Config.URANUS_SPACE_STATION_ID, Config.URANUS_SPACE_STATION_STATIC_ID, WorldProviderUranusOrbit.class);
            URANUS_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            URANUS_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            URANUS_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.NEPTUNE_SPACE_STATION && Config.NEPTUNE) {
            NEPTUNE_SPACE_STATION = new Satellite("space_station.neptune").setParentBody(ExtraPlanets_Planets.NEPTUNE);
            NEPTUNE_SPACE_STATION.setRelativeSize(0.2667f);
            NEPTUNE_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            NEPTUNE_SPACE_STATION.setRelativeOrbitTime(20.0f);
            NEPTUNE_SPACE_STATION.setTierRequired(ExtraPlanets_Planets.NEPTUNE.getTierRequirement());
            NEPTUNE_SPACE_STATION.setDimensionInfo(Config.NEPTUNE_SPACE_STATION_ID, Config.NEPTUNE_SPACE_STATION_STATIC_ID, WorldProviderNeptuneOrbit.class);
            NEPTUNE_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            NEPTUNE_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            NEPTUNE_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.PLUTO_SPACE_STATION && Config.PLUTO) {
            PLUTO_SPACE_STATION = new Satellite("space_station.pluto").setParentBody(ExtraPlanets_Planets.PLUTO);
            PLUTO_SPACE_STATION.setRelativeSize(0.2667f);
            PLUTO_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            PLUTO_SPACE_STATION.setRelativeOrbitTime(20.0f);
            PLUTO_SPACE_STATION.setTierRequired(ExtraPlanets_Planets.PLUTO.getTierRequirement());
            PLUTO_SPACE_STATION.setDimensionInfo(Config.PLUTO_SPACE_STATION_ID, Config.PLUTO_SPACE_STATION_STATIC_ID, WorldProviderPlutoOrbit.class);
            PLUTO_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            PLUTO_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            PLUTO_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.ERIS_SPACE_STATION && Config.ERIS) {
            ERIS_SPACE_STATION = new Satellite("space_station.eris").setParentBody(ExtraPlanets_Planets.ERIS);
            ERIS_SPACE_STATION.setRelativeSize(0.2667f);
            ERIS_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            ERIS_SPACE_STATION.setRelativeOrbitTime(20.0f);
            ERIS_SPACE_STATION.setTierRequired(ExtraPlanets_Planets.ERIS.getTierRequirement());
            ERIS_SPACE_STATION.setDimensionInfo(Config.ERIS_SPACE_STATION_ID, Config.ERIS_SPACE_STATION_STATIC_ID, WorldProviderErisOrbit.class);
            ERIS_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            ERIS_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            ERIS_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
        if (Config.KEPLER22B_SPACE_STATION && Config.KEPLER22B && Config.KEPLER_SOLAR_SYSTEMS) {
            KEPLER22B_SPACE_STATION = new Satellite("space_station.kepler22b").setParentBody(ExtraPlanets_Planets.KEPLER22B);
            KEPLER22B_SPACE_STATION.setRelativeSize(0.2667f);
            KEPLER22B_SPACE_STATION.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.5f, 5.5f));
            KEPLER22B_SPACE_STATION.setRelativeOrbitTime(20.0f);
            KEPLER22B_SPACE_STATION.setTierRequired(ExtraPlanets_Planets.KEPLER22B.getTierRequirement());
            KEPLER22B_SPACE_STATION.setDimensionInfo(Config.KEPLER22B_SPACE_STATION_ID, Config.KEPLER22B_SPACE_STATION_STATIC_ID, WorldProviderKepler22bOrbit.class);
            KEPLER22B_SPACE_STATION.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
            KEPLER22B_SPACE_STATION.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            KEPLER22B_SPACE_STATION.setBiomeInfo(new Biome[]{BiomeOrbit.space});
        }
    }

    private static void registerSatellites() {
        if (Config.MERCURY_SPACE_STATION && Config.MERCURY) {
            GalaxyRegistry.registerSatellite((Satellite)MERCURY_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderMercuryOrbit.class, (ITeleportType)new TeleportTypeMercuryOrbit());
            GalacticraftRegistry.registerDimension((String)"Mercury Space Station", (String)"_mercury_orbit", (int)Config.MERCURY_SPACE_STATION_ID, WorldProviderMercuryOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Mercury Space Station", (String)"_mercury_orbit", (int)Config.MERCURY_SPACE_STATION_STATIC_ID, WorldProviderMercuryOrbit.class, (boolean)true);
        }
        if (Config.VENUS_SPACE_STATION) {
            GalaxyRegistry.registerSatellite((Satellite)VENUS_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderVenusOrbit.class, (ITeleportType)new TeleportTypeVenusOrbit());
            GalacticraftRegistry.registerDimension((String)"Venus Space Station", (String)"_venus_orbit", (int)Config.VENUS_SPACE_STATION_ID, WorldProviderVenusOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Venus Space Station", (String)"_venus_orbit", (int)Config.VENUS_SPACE_STATION_STATIC_ID, WorldProviderVenusOrbit.class, (boolean)true);
        }
        if (Config.CERES_SPACE_STATION && Config.CERES) {
            GalaxyRegistry.registerSatellite((Satellite)CERES_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderCeresOrbit.class, (ITeleportType)new TeleportTypeCeresOrbit());
            GalacticraftRegistry.registerDimension((String)"Ceres Space Station", (String)"_ceres_orbit", (int)Config.CERES_SPACE_STATION_ID, WorldProviderCeresOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Ceres Space Station", (String)"_ceres_orbit", (int)Config.CERES_SPACE_STATION_STATIC_ID, WorldProviderCeresOrbit.class, (boolean)true);
        }
        if (Config.MARS_SPACE_STATION && MarsModule.planetMars != null) {
            GalaxyRegistry.registerSatellite((Satellite)MARS_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderMarsOrbit.class, (ITeleportType)new TeleportTypeMarsOrbit());
            GalacticraftRegistry.registerDimension((String)"Mars Space Station", (String)"_mars_orbit", (int)Config.MARS_SPACE_STATION_ID, WorldProviderMarsOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Mars Space Station", (String)"_mars_orbit", (int)Config.MARS_SPACE_STATION_STATIC_ID, WorldProviderMarsOrbit.class, (boolean)true);
        }
        if (Config.JUPITER_SPACE_STATION && Config.JUPITER) {
            GalaxyRegistry.registerSatellite((Satellite)JUPITER_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderJupiterOrbit.class, (ITeleportType)new TeleportTypeJupiterOrbit());
            GalacticraftRegistry.registerDimension((String)"Jupiter Space Station", (String)"_jupiter_orbit", (int)Config.JUPITER_SPACE_STATION_ID, WorldProviderJupiterOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Jupiter Space Station", (String)"_jupiter_orbit", (int)Config.JUPITER_SPACE_STATION_STATIC_ID, WorldProviderJupiterOrbit.class, (boolean)true);
        }
        if (Config.SATURN_SPACE_STATION && Config.SATURN) {
            GalaxyRegistry.registerSatellite((Satellite)SATURN_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderSaturnOrbit.class, (ITeleportType)new TeleportTypeSaturnOrbit());
            GalacticraftRegistry.registerDimension((String)"Saturn Space Station", (String)"_saturn_orbit", (int)Config.SATURN_SPACE_STATION_ID, WorldProviderSaturnOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Saturn Space Station", (String)"_saturn_orbit", (int)Config.SATURN_SPACE_STATION_STATIC_ID, WorldProviderSaturnOrbit.class, (boolean)true);
        }
        if (Config.URANUS_SPACE_STATION && Config.URANUS) {
            GalaxyRegistry.registerSatellite((Satellite)URANUS_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderUranusOrbit.class, (ITeleportType)new TeleportTypeUranusOrbit());
            GalacticraftRegistry.registerDimension((String)"Uranus Space Station", (String)"_uranus_orbit", (int)Config.URANUS_SPACE_STATION_ID, WorldProviderUranusOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Uranus Space Station", (String)"_uranus_orbit", (int)Config.URANUS_SPACE_STATION_STATIC_ID, WorldProviderUranusOrbit.class, (boolean)true);
        }
        if (Config.NEPTUNE_SPACE_STATION && Config.NEPTUNE) {
            GalaxyRegistry.registerSatellite((Satellite)NEPTUNE_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderNeptuneOrbit.class, (ITeleportType)new TeleportTypeNeptuneOrbit());
            GalacticraftRegistry.registerDimension((String)"Neptune Space Station", (String)"_neptune_orbit", (int)Config.NEPTUNE_SPACE_STATION_ID, WorldProviderNeptuneOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Neptune Space Station", (String)"_neptune_orbit", (int)Config.NEPTUNE_SPACE_STATION_STATIC_ID, WorldProviderNeptuneOrbit.class, (boolean)true);
        }
        if (Config.PLUTO_SPACE_STATION && Config.PLUTO) {
            GalaxyRegistry.registerSatellite((Satellite)PLUTO_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderPlutoOrbit.class, (ITeleportType)new TeleportTypePlutoOrbit());
            GalacticraftRegistry.registerDimension((String)"Pluto Space Station", (String)"_pluto_orbit", (int)Config.PLUTO_SPACE_STATION_ID, WorldProviderPlutoOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Pluto Space Station", (String)"_pluto_orbit", (int)Config.PLUTO_SPACE_STATION_STATIC_ID, WorldProviderPlutoOrbit.class, (boolean)true);
        }
        if (Config.ERIS_SPACE_STATION && Config.ERIS) {
            GalaxyRegistry.registerSatellite((Satellite)ERIS_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderErisOrbit.class, (ITeleportType)new TeleportTypeErisOrbit());
            GalacticraftRegistry.registerDimension((String)"Eris Space Station", (String)"_eris_orbit", (int)Config.ERIS_SPACE_STATION_ID, WorldProviderErisOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Eris Space Station", (String)"_eris_orbit", (int)Config.ERIS_SPACE_STATION_STATIC_ID, WorldProviderErisOrbit.class, (boolean)true);
        }
        if (Config.KEPLER22B_SPACE_STATION && Config.KEPLER22B && Config.KEPLER_SOLAR_SYSTEMS) {
            GalaxyRegistry.registerSatellite((Satellite)KEPLER22B_SPACE_STATION);
            GalacticraftRegistry.registerTeleportType(WorldProviderKepler22bOrbit.class, (ITeleportType)new TeleportTypeKepler22bOrbit());
            GalacticraftRegistry.registerDimension((String)"Kepler22b Space Station", (String)"_kepler22b_orbit", (int)Config.KEPLER22B_SPACE_STATION_ID, WorldProviderKepler22bOrbit.class, (boolean)false);
            GalacticraftRegistry.registerDimension((String)"Kepler22b Space Station", (String)"_kepler22b_orbit", (int)Config.KEPLER22B_SPACE_STATION_STATIC_ID, WorldProviderKepler22bOrbit.class, (boolean)true);
        }
    }
}

