/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.entities.landers;

import com.mjr.mjrlegendslib.util.TranslateUtilities;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.fx.ParticleLanderFlame;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNeptuneLander
extends EntityLanderBase
implements IIgnoreShift,
ICameraZoomEntity {
    private double lastMotionY;

    public EntityNeptuneLander(World world) {
        super(world);
        this.func_70105_a(3.0f, 4.25f);
    }

    public EntityNeptuneLander(EntityPlayerMP player) {
        super(player, 0.0f);
    }

    public double func_70042_X() {
        return 2.25;
    }

    public float getRotateOffset() {
        return 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.lastMotionY = this.field_70181_x;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.lastMotionY = this.field_70181_x;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    public String func_70005_c_() {
        return TranslateUtilities.translate((String)"container.lander.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E) {
                return false;
            }
            if (!this.func_184188_bt().isEmpty()) {
                this.func_184226_ay();
            }
            return true;
        }
        if (this.func_184188_bt().isEmpty() && player instanceof EntityPlayerMP) {
            GCCoreUtil.openParachestInv((EntityPlayerMP)((EntityPlayerMP)player), (EntityLanderBase)this);
            return true;
        }
        if (player instanceof EntityPlayerMP) {
            if (!this.field_70122_E) {
                return false;
            }
            this.func_184226_ay();
            return true;
        }
        return true;
    }

    public boolean pressKey(int key) {
        if (this.field_70122_E) {
            return false;
        }
        float turnFactor = 2.0f;
        float angle = 45.0f;
        switch (key) {
            case 0: {
                this.field_70125_A = Math.min(Math.max(this.field_70125_A - 0.5f * turnFactor, -angle), angle);
                return true;
            }
            case 1: {
                this.field_70125_A = Math.min(Math.max(this.field_70125_A + 0.5f * turnFactor, -angle), angle);
                return true;
            }
            case 2: {
                this.field_70177_z -= 0.5f * turnFactor;
                return true;
            }
            case 3: {
                this.field_70177_z += 0.5f * turnFactor;
                return true;
            }
            case 4: {
                this.field_70181_x = Math.min(this.field_70181_x + (double)0.03f, this.field_70163_u < 90.0 ? -0.15 : -1.0);
                return true;
            }
            case 5: {
                this.field_70181_x = Math.min(this.field_70181_x - (double)0.022f, -1.0);
                return true;
            }
        }
        return false;
    }

    public boolean shouldSpawnParticles() {
        return this.ticks > 40L && this.field_70125_A != 1.0E-7f;
    }

    public Map<Vector3, Vector3> getParticleMap() {
        double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
        double x1 = 4.0 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
        double z1 = 4.0 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
        double y1 = -4.0 * Math.abs(Math.cos((double)this.field_70125_A / 57.29577951308232));
        new Vector3((Entity)this);
        HashMap<Vector3, Vector3> particleMap = new HashMap<Vector3, Vector3>();
        particleMap.put(new Vector3(this.field_70165_t, this.field_70163_u + 1.0 + this.field_70181_x / 2.0, this.field_70161_v), new Vector3(x1, y1 + this.field_70181_x / 2.0, z1));
        return particleMap;
    }

    @SideOnly(value=Side.CLIENT)
    public Particle getParticle(Random rand, double x, double y, double z, double motX, double motY, double motZ) {
        EntityLivingBase passenger = this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityLivingBase) ? null : (EntityLivingBase)this.func_184188_bt().get(0);
        return new ParticleLanderFlame(this.field_70170_p, x, y, z, motX, motY, motZ, passenger);
    }

    public void tickInAir() {
        super.tickInAir();
        if (this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E) {
                this.field_70181_x -= 0.016;
            }
            double motY = -1.0 * Math.sin((double)this.field_70125_A / 57.29577951308232);
            double motX = Math.cos((double)this.field_70177_z / 57.29577951308232) * motY;
            double motZ = Math.sin((double)this.field_70177_z / 57.29577951308232) * motY;
            this.field_70159_w = motX / 2.0;
            this.field_70179_y = motZ / 2.0;
        }
    }

    public void tickOnGround() {
        this.field_70125_A = 1.0E-7f;
    }

    public void onGroundHit() {
        if (!this.field_70170_p.field_72995_K && Math.abs(this.lastMotionY) > 2.0) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_184210_p();
                if (entity instanceof EntityPlayerMP) {
                    GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[0]), (EntityPlayerMP)entity);
                }
                entity.field_70159_w = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70179_y = 0.0;
                entity.func_70107_b(entity.field_70165_t, this.field_70163_u + this.func_70042_X(), entity.field_70161_v);
                this.field_70170_p.func_72866_a(entity, false);
            }
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 12.0f, true);
            this.func_70106_y();
        }
    }

    public Vector3 getMotionVec() {
        if (this.field_70122_E) {
            return new Vector3(0.0, 0.0, 0.0);
        }
        if (this.ticks >= 40L && this.ticks < 45L) {
            this.field_70181_x = this.getInitialMotionY();
        }
        return new Vector3(this.field_70159_w, this.ticks < 40L ? 0.0 : this.field_70181_x, this.field_70179_y);
    }

    public float getCameraZoom() {
        return 15.0f;
    }

    public boolean defaultThirdPerson() {
        return true;
    }

    public boolean shouldIgnoreShiftExit() {
        return !this.field_70122_E;
    }

    public double getInitialMotionY() {
        return -2.5;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }
}

