/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.api.prefabs.entity;

import com.google.common.base.Predicate;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.api.entity.ITelemetry;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.screen.GameScreenText;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class EntityElectricSpaceshipBase
extends Entity
implements IPacketReceiver,
IIgnoreShift,
ITelemetry {
    public int launchPhase;
    protected long ticks = 0L;
    protected double dragAir;
    public int timeUntilLaunch;
    public float timeSinceLaunch;
    public float rollAmplitude;
    public float shipDamage;
    private ArrayList<BlockVec3Dim> telemetryList = new ArrayList();
    private boolean addToTelemetry = false;
    private double syncAdjustX = 0.0;
    private double syncAdjustY = 0.0;
    private double syncAdjustZ = 0.0;
    private boolean syncAdjustFlag = false;
    protected float currentPowerCapacity;
    protected float powerMaxCapacity;
    public static final Predicate<Entity> rocketSelector = new Predicate<Entity>(){

        public boolean apply(Entity e) {
            return e instanceof EntitySpaceshipBase && e.func_70089_S();
        }
    };

    public EntityElectricSpaceshipBase(World par1World) {
        super(par1World);
        this.launchPhase = EnumLaunchPhase.UNIGNITED.ordinal();
        this.field_70156_m = true;
        this.field_70158_ak = true;
    }

    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * 5.0) * d0;
    }

    public abstract int getPreLaunchWait();

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag = par1DamageSource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)par1DamageSource.func_76346_g()).field_71075_bZ.field_75098_d;
            Entity e = par1DamageSource.func_76346_g();
            if (this.func_180431_b(par1DamageSource) || this.field_70163_u > 300.0 || e instanceof EntityLivingBase && !(e instanceof EntityPlayer)) {
                return false;
            }
            this.rollAmplitude = 10.0f;
            this.func_70018_K();
            this.shipDamage += par2 * 10.0f;
            if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
                this.shipDamage = 100.0f;
            }
            if (flag || this.shipDamage > 90.0f && !this.field_70170_p.field_72995_K) {
                this.func_184226_ay();
                if (flag) {
                    this.func_70106_y();
                } else {
                    this.func_70106_y();
                    this.dropShipAsItem();
                }
                return true;
            }
            return true;
        }
        return true;
    }

    public void dropShipAsItem() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (ItemStack item : this.getItemsDropped(new ArrayList<ItemStack>())) {
            EntityItem EntityItem2 = this.func_70099_a(item, 0.0f);
            if (!item.func_77942_o()) continue;
            EntityItem2.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
        }
    }

    public abstract List<ItemStack> getItemsDropped(List<ItemStack> var1);

    public void func_70057_ab() {
        this.rollAmplitude = 5.0f;
        this.shipDamage += this.shipDamage * 10.0f;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void func_70071_h_() {
        AxisAlignedBB box;
        List var15;
        ++this.ticks;
        super.func_70071_h_();
        if (this.addToTelemetry) {
            this.addToTelemetry = false;
            for (BlockVec3Dim vec : new ArrayList<BlockVec3Dim>(this.telemetryList)) {
                TileEntity t1 = vec.getTileEntityNoLoad();
                if (!(t1 instanceof TileEntityTelemetry) || t1.func_145837_r() || ((TileEntityTelemetry)t1).linkedEntity != this) continue;
                ((TileEntityTelemetry)t1).addTrackedEntity((Entity)this);
            }
        }
        for (Entity e : this.func_184188_bt()) {
            e.field_70143_R = 0.0f;
        }
        double d = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
        if (this.field_70163_u > d && this.launchPhase != EnumLaunchPhase.LANDING.ordinal()) {
            this.onReachAtmosphere();
        }
        if (this.rollAmplitude > 0.0f) {
            this.rollAmplitude -= 1.0f;
        }
        if (this.shipDamage > 0.0f) {
            this.shipDamage -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70163_u < 0.0) {
                this.func_70106_y();
            } else {
                double d2 = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
                int n = this.launchPhase == EnumLaunchPhase.LANDING.ordinal() ? 355 : 100;
                if (this.field_70163_u > d2 + (double)n) {
                    for (Entity e : this.func_184188_bt()) {
                        if (e instanceof EntityPlayerMP) {
                            GCPlayerStats stats = GCPlayerStats.get((Entity)e);
                            if (!stats.isUsingPlanetSelectionGui()) continue;
                            this.func_70106_y();
                            continue;
                        }
                        this.func_70106_y();
                    }
                }
            }
            if (this.timeSinceLaunch > 50.0f && this.field_70122_E) {
                this.failRocket();
            }
        }
        if (this.launchPhase == EnumLaunchPhase.UNIGNITED.ordinal()) {
            this.timeUntilLaunch = this.getPreLaunchWait();
        }
        this.timeSinceLaunch = this.launchPhase >= EnumLaunchPhase.LAUNCHED.ordinal() ? (this.timeSinceLaunch += 1.0f) : 0.0f;
        if (this.timeUntilLaunch > 0 && this.launchPhase == EnumLaunchPhase.IGNITED.ordinal()) {
            --this.timeUntilLaunch;
        }
        if ((var15 = this.field_70170_p.func_72839_b((Entity)this, box = this.func_174813_aQ().func_72321_a(0.2, 0.2, 0.2))) != null && !var15.isEmpty()) {
            for (int var52 = 0; var52 < var15.size(); ++var52) {
                Entity var17 = (Entity)var15.get(var52);
                if (!this.func_184188_bt().contains(var17)) continue;
                var17.func_70108_f((Entity)this);
            }
        }
        if (this.timeUntilLaunch == 0 && this.launchPhase == EnumLaunchPhase.IGNITED.ordinal()) {
            this.setLaunchPhase(EnumLaunchPhase.LAUNCHED);
            this.onLaunch();
        }
        if (this.field_70125_A > 90.0f) {
            this.field_70125_A = 90.0f;
        }
        if (this.field_70125_A < -90.0f) {
            this.field_70125_A = -90.0f;
        }
        this.field_70159_w = -(50.0 * Math.cos((double)this.field_70177_z / 57.29577951308232) * Math.sin((double)this.field_70125_A * 0.01 / 57.29577951308232));
        this.field_70179_y = -(50.0 * Math.sin((double)this.field_70177_z / 57.29577951308232) * Math.sin((double)this.field_70125_A * 0.01 / 57.29577951308232));
        if (this.launchPhase < EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.shouldMoveClientSide()) {
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        } else {
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K && this.ticks % 3L == 0L) {
            GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketDynamic((Entity)this), this.field_70170_p.field_73011_w.getDimension());
        }
    }

    protected boolean shouldMoveClientSide() {
        return true;
    }

    public abstract boolean hasValidPower();

    public void decodePacketdata(ByteBuf buffer) {
        int newLaunchPhase;
        if (!this.field_70170_p.field_72995_K) {
            new Exception().printStackTrace();
        }
        if (this.launchPhase != (newLaunchPhase = buffer.readInt())) {
            this.setLaunchPhase(EnumLaunchPhase.values()[newLaunchPhase]);
            if (newLaunchPhase == EnumLaunchPhase.LANDING.ordinal()) {
                this.syncAdjustFlag = true;
            }
        } else if (this.hasValidPower()) {
            if (Math.abs(this.syncAdjustX - this.field_70165_t) > 0.2) {
                this.field_70159_w += (this.syncAdjustX - this.field_70165_t) / 40.0;
            }
            if (Math.abs(this.syncAdjustY - this.field_70163_u) > 0.2) {
                this.field_70181_x += (this.syncAdjustY - this.field_70163_u) / 40.0;
            }
            if (Math.abs(this.syncAdjustZ - this.field_70161_v) > 0.2) {
                this.field_70179_y += (this.syncAdjustZ - this.field_70161_v) / 40.0;
            }
        }
        this.timeSinceLaunch = buffer.readFloat();
        this.timeUntilLaunch = buffer.readInt();
    }

    public void getNetworkedData(ArrayList<Object> list) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        list.add(this.launchPhase);
        list.add(Float.valueOf(this.timeSinceLaunch));
        list.add(this.timeUntilLaunch);
    }

    public void turnYaw(float f) {
        this.field_70177_z += f;
    }

    public void turnPitch(float f) {
        this.field_70125_A += f;
    }

    protected void failRocket() {
        for (Entity passenger : this.func_184188_bt()) {
            passenger.func_70097_a((DamageSource)DamageSourceGC.spaceshipCrash, 81.0f);
        }
        if (!ConfigManagerCore.disableSpaceshipGrief) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
        }
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean b) {
        this.func_70101_b(yaw, pitch);
        if (this.syncAdjustFlag && this.field_70170_p.func_175667_e(new BlockPos(x, 255.0, z)) && this.hasValidPower()) {
            EntityPlayerSP p = FMLClientHandler.instance().getClientPlayerEntity();
            double dx = x - p.field_70165_t;
            double dz = z - p.field_70161_v;
            if (dx * dx + dz * dz < 1024.0) {
                if (!this.field_70170_p.field_72996_f.contains((Object)this)) {
                    try {
                        this.field_70170_p.field_72996_f.add(this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.field_70165_t = x;
                this.field_70163_u = y;
                this.field_70161_v = z;
                int cx = MathHelper.func_76128_c((double)(x / 16.0));
                int cz = MathHelper.func_76128_c((double)(z / 16.0));
                if (!this.field_70175_ag || this.field_70176_ah != cx || this.field_70164_aj != cz) {
                    if (this.field_70175_ag && this.field_70170_p.func_175668_a(new BlockPos(this.field_70176_ah << 4, 255, this.field_70164_aj << 4), true)) {
                        this.field_70170_p.func_72964_e(this.field_70176_ah, this.field_70164_aj).func_76608_a((Entity)this, this.field_70162_ai);
                    }
                    this.field_70175_ag = true;
                    this.field_70170_p.func_72964_e(cx, cz).func_76612_a((Entity)this);
                }
                this.syncAdjustX = 0.0;
                this.syncAdjustY = 0.0;
                this.syncAdjustZ = 0.0;
                this.syncAdjustFlag = false;
            }
        } else {
            this.syncAdjustX = x;
            this.syncAdjustY = y;
            this.syncAdjustZ = z;
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("launchPhase", this.launchPhase + 1);
        nbt.func_74768_a("timeUntilLaunch", this.timeUntilLaunch);
        if (this.telemetryList.size() > 0) {
            NBTTagList teleNBTList = new NBTTagList();
            for (BlockVec3Dim vec : new ArrayList<BlockVec3Dim>(this.telemetryList)) {
                NBTTagCompound tag = new NBTTagCompound();
                vec.writeToNBT(tag);
                teleNBTList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("telemetryList", (NBTBase)teleNBTList);
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        NBTTagList teleNBT;
        this.timeUntilLaunch = nbt.func_74762_e("timeUntilLaunch");
        boolean hasOldTags = false;
        if (nbt.func_150296_c().contains("launched")) {
            hasOldTags = true;
            boolean launched = nbt.func_74767_n("launched");
            if (launched) {
                this.setLaunchPhase(EnumLaunchPhase.LAUNCHED);
            }
        }
        if (nbt.func_150296_c().contains("ignite")) {
            hasOldTags = true;
            int ignite = nbt.func_74762_e("ignite");
            if (ignite == 1) {
                this.setLaunchPhase(EnumLaunchPhase.IGNITED);
            }
        }
        if (hasOldTags) {
            if (this.launchPhase < EnumLaunchPhase.LAUNCHED.ordinal() && this.launchPhase != EnumLaunchPhase.IGNITED.ordinal()) {
                this.setLaunchPhase(EnumLaunchPhase.UNIGNITED);
            }
        } else {
            this.setLaunchPhase(EnumLaunchPhase.values()[nbt.func_74762_e("launchPhase") - 1]);
        }
        this.telemetryList.clear();
        if (nbt.func_74764_b("telemetryList") && (teleNBT = nbt.func_150295_c("telemetryList", 10)).func_74745_c() > 0) {
            for (int j = teleNBT.func_74745_c() - 1; j >= 0; --j) {
                NBTTagCompound tag1 = teleNBT.func_150305_b(j);
                if (tag1 == null) continue;
                this.telemetryList.add(BlockVec3Dim.readFromNBT((NBTTagCompound)tag1));
            }
            this.addToTelemetry = true;
        }
    }

    public boolean getLaunched() {
        return this.launchPhase >= EnumLaunchPhase.LAUNCHED.ordinal();
    }

    public boolean canBeRidden() {
        return false;
    }

    public void ignite() {
        this.setLaunchPhase(EnumLaunchPhase.IGNITED);
    }

    public double func_70042_X() {
        return -0.9;
    }

    public double getOnPadYOffset() {
        return 0.0;
    }

    public void onLaunch() {
        MinecraftForge.EVENT_BUS.post((Event)new RocketLaunchEvent(this));
    }

    public void onReachAtmosphere() {
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(String var1, double var2, double var4, double var6, double var8, double var10, double var12) {
    }

    public boolean canRiderInteract() {
        return true;
    }

    public ResourceLocation getSpaceshipGui() {
        return GalacticraftRegistry.getResouceLocationForDimension(this.field_70170_p.field_73011_w.getClass());
    }

    public void setLaunchPhase(EnumLaunchPhase phase) {
        this.launchPhase = phase.ordinal();
    }

    public boolean shouldIgnoreShiftExit() {
        return this.launchPhase >= EnumLaunchPhase.LAUNCHED.ordinal();
    }

    public void addTelemetry(TileEntityTelemetry tile) {
        this.telemetryList.add(new BlockVec3Dim((TileEntity)tile));
    }

    public ArrayList<TileEntityTelemetry> getTelemetry() {
        ArrayList<TileEntityTelemetry> returnList = new ArrayList<TileEntityTelemetry>();
        for (BlockVec3Dim vec : new ArrayList<BlockVec3Dim>(this.telemetryList)) {
            TileEntity t1 = vec.getTileEntity();
            if (!(t1 instanceof TileEntityTelemetry) || t1.func_145837_r() || ((TileEntityTelemetry)t1).linkedEntity != this) continue;
            returnList.add((TileEntityTelemetry)t1);
        }
        return returnList;
    }

    public void transmitData(int[] data) {
        data[0] = this.timeUntilLaunch;
        data[1] = (int)this.field_70163_u;
        data[3] = (int)this.currentPowerCapacity;
        data[4] = (int)this.field_70125_A;
    }

    public void receiveData(int[] data, String[] str) {
        int countdown = data[0];
        str[0] = "";
        str[1] = countdown == 400 ? TranslateUtilities.translate((String)"gui.rocket.on_launchpad") : (countdown > 0 ? TranslateUtilities.translate((String)"gui.rocket.countdown") + ": " + countdown / 20 : TranslateUtilities.translate((String)"gui.rocket.launched"));
        str[2] = TranslateUtilities.translate((String)"gui.rocket.height") + ": " + data[1];
        str[3] = GameScreenText.makeSpeedString((int)data[2]);
        str[4] = TranslateUtilities.translate((String)"gui.message.fuel.name") + ": " + data[3] + "%";
    }

    public void adjustDisplay(int[] data) {
        GL11.glRotatef((float)data[4], (float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(this.field_70131_O / 4.0f), (float)0.0f);
    }

    public float getRenderOffsetY() {
        return 1.34f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        BlockPos blockpos;
        double height = this.field_70163_u + (double)this.func_70047_e();
        if (height > 255.0) {
            height = 255.0;
        }
        return this.field_70170_p.func_175667_e(blockpos = new BlockPos(this.field_70165_t, height, this.field_70161_v)) ? this.field_70170_p.func_175626_b(blockpos, 0) : 0;
    }

    public static class RocketLaunchEvent
    extends EntityEvent {
        public final EntityElectricSpaceshipBase rocket;

        public RocketLaunchEvent(EntityElectricSpaceshipBase entity) {
            super((Entity)entity);
            this.rocket = entity;
        }
    }

    public static enum EnumLaunchPhase {
        UNIGNITED,
        IGNITED,
        LAUNCHED,
        LANDING;

    }
}

