/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.markdown;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Lazy;
import logisticspipes.kotlin.LazyKt;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.Triple;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin._Assertions;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.collections.IntIterator;
import logisticspipes.kotlin.jvm.functions.Function0;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.functions.Function2;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.jvm.internal.Ref;
import logisticspipes.kotlin.ranges.IntRange;
import logisticspipes.kotlin.ranges.RangesKt;
import logisticspipes.kotlin.sequences.Sequence;
import logisticspipes.kotlin.sequences.SequencesKt;
import logisticspipes.kotlin.text.CharsKt;
import logisticspipes.kotlin.text.MatchGroup;
import logisticspipes.kotlin.text.MatchResult;
import logisticspipes.kotlin.text.Regex;
import logisticspipes.kotlin.text.RegexOption;
import logisticspipes.kotlin.text.StringsKt;
import network.rs485.markdown.Break;
import network.rs485.markdown.HeaderParagraph;
import network.rs485.markdown.HorizontalLineParagraph;
import network.rs485.markdown.ImageParagraph;
import network.rs485.markdown.InlineElement;
import network.rs485.markdown.Link;
import network.rs485.markdown.LinkWord;
import network.rs485.markdown.MarkdownParser;
import network.rs485.markdown.MenuParagraph;
import network.rs485.markdown.PageLink;
import network.rs485.markdown.Paragraph;
import network.rs485.markdown.RegularParagraph;
import network.rs485.markdown.Space;
import network.rs485.markdown.TextFormat;
import network.rs485.markdown.TextFormatting;
import network.rs485.markdown.WebLink;
import network.rs485.markdown.Word;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002)*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0002J,\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u0006H\u0002Jf\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\u0019\u001a\u00020\u001a20\u0010\u001b\u001a,\u0012\u0004\u0012\u00020\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dj\u0002`\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00040\u001c2\u001c\u0010 \u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00040\u001dj\u0002`!H\u0002J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00042\u0006\u0010\u0014\u001a\u00020\fJ\u0012\u0010$\u001a\u0004\u0018\u00010\u001e2\u0006\u0010%\u001a\u00020\fH\u0002J7\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u001a\b\u0002\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dj\u0002`\u001fH\u0000\u00a2\u0006\u0002\b'J\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b(R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lnetwork/rs485/markdown/MarkdownParser;", "", "()V", "boldItalicRegexes", "", "Llogisticspipes/kotlin/Pair;", "", "Llogisticspipes/kotlin/text/Regex;", "htmlBreakRegex", "linkRegex", "webLinkRegex", "bufferOrReturnLine", "", "line", "buffer", "Ljava/lang/StringBuilder;", "Llogisticspipes/kotlin/text/StringBuilder;", "countChars", "char", "", "str", "index", "maximum", "parseLinks", "Lnetwork/rs485/markdown/InlineElement;", "inputChars", "", "splitSpacesAndWords", "Llogisticspipes/kotlin/Function2;", "Llogisticspipes/kotlin/Function1;", "Lnetwork/rs485/markdown/Word;", "Lnetwork/rs485/markdown/WordCreator;", "splitWhitespaceCharactersAndWords", "Lnetwork/rs485/markdown/TextToElements;", "parseParagraphs", "Lnetwork/rs485/markdown/Paragraph;", "parseTextElement", "word", "makeWord", "splitSpacesAndWords$logisticspipes", "splitWhitespaceCharactersAndWords$logisticspipes", "LinkMatcher", "ReplacedCharSequence", "logisticspipes"})
public final class MarkdownParser {
    private static final Regex linkRegex;
    private static final Regex webLinkRegex;
    private static final List<Pair<Integer, Regex>> boldItalicRegexes;
    private static final Regex htmlBreakRegex;
    public static final MarkdownParser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InlineElement> splitWhitespaceCharactersAndWords$logisticspipes(@NotNull CharSequence inputChars) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(inputChars, "inputChars");
        String chars = htmlBreakRegex.replace(inputChars, "\n");
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)chars, new char[]{'\n'}, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void words;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = CollectionsKt.plus((Collection)MarkdownParser.splitSpacesAndWords$logisticspipes$default(INSTANCE, (CharSequence)words, null, 2, null), (Iterable)CollectionsKt.listOf(Break.INSTANCE));
            collection.add(list);
        }
        return CollectionsKt.dropLast(CollectionsKt.flatten((List)destination$iv$iv), 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InlineElement> splitSpacesAndWords$logisticspipes(@NotNull CharSequence inputChars, @NotNull Function1<? super String, ? extends Word> makeWord) {
        void startIdx;
        Intrinsics.checkNotNullParameter(inputChars, "inputChars");
        Intrinsics.checkNotNullParameter(makeWord, "makeWord");
        CharSequence textLine = StringsKt.trimEnd(inputChars);
        ReplacedCharSequence replacingChars = new ReplacedCharSequence(textLine);
        Iterable $this$forEach$iv = boldItalicRegexes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$level$regex = (Pair)element$iv;
            boolean bl = false;
            int n = ((Number)$dstr$level$regex.component1()).intValue();
            Regex regex = (Regex)$dstr$level$regex.component2();
            Sequence $this$forEach$iv2 = Regex.findAll$default(regex, replacingChars, 0, 2, null);
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                MatchGroup textGroup;
                EnumSet<Enum> enumSet;
                void level;
                Object element$iv2 = iterator2.next();
                MatchResult match = (MatchResult)element$iv2;
                boolean bl2 = false;
                EnumSet<TextFormat> lastFormat = replacingChars.getFormatting(match.getRange());
                switch (level) {
                    case 3: {
                        enumSet = EnumSet.of((Enum)TextFormat.Italic, (Enum)TextFormat.Bold);
                        break;
                    }
                    case 2: {
                        enumSet = EnumSet.of((Enum)TextFormat.Bold);
                        break;
                    }
                    case 1: {
                        enumSet = EnumSet.of((Enum)TextFormat.Italic);
                        break;
                    }
                    default: {
                        enumSet = TextFormat.Companion.getNone();
                    }
                }
                EnumSet<Enum> enumSet2 = enumSet;
                int n2 = 0;
                boolean bl3 = false;
                EnumSet<Enum> it = enumSet2;
                boolean bl4 = false;
                it.addAll((Collection<TextFormat>)lastFormat);
                EnumSet<Enum> format = enumSet2;
                Intrinsics.checkNotNull(match.getGroups().get(1));
                if (match.getRange().getFirst() > 0 && !CharsKt.isWhitespace(textLine.charAt(textGroup.getRange().getFirst())) && CharsKt.isWhitespace(textLine.charAt(match.getRange().getFirst() - 1))) {
                    replacingChars.addReplacement(RangesKt.until(match.getRange().getFirst() - 1, match.getRange().getFirst()), Space.INSTANCE);
                }
                IntRange intRange = RangesKt.until(match.getRange().getFirst(), textGroup.getRange().getFirst());
                EnumSet<Enum> enumSet3 = format;
                Intrinsics.checkNotNullExpressionValue(enumSet3, "format");
                replacingChars.addReplacement(intRange, new TextFormatting(enumSet3));
                if (match.getRange().getFirst() > 0 && CharsKt.isWhitespace(textLine.charAt(textGroup.getRange().getFirst()))) {
                    n2 = textGroup.getRange().getFirst();
                    replacingChars.addReplacement(new IntRange(n2, textGroup.getRange().getFirst()), Space.INSTANCE);
                }
                if (match.getRange().getLast() + 1 < textLine.length() && CharsKt.isWhitespace(textLine.charAt(textGroup.getRange().getLast()))) {
                    n2 = textGroup.getRange().getLast();
                    replacingChars.addReplacement(new IntRange(n2, textGroup.getRange().getLast()), Space.INSTANCE);
                }
                n2 = textGroup.getRange().getLast() + 1;
                replacingChars.addReplacement(new IntRange(n2, match.getRange().getLast()), new TextFormatting(lastFormat));
                if (match.getRange().getLast() + 1 >= textLine.length() || CharsKt.isWhitespace(textLine.charAt(textGroup.getRange().getLast())) || !CharsKt.isWhitespace(textLine.charAt(match.getRange().getLast() + 1))) continue;
                n2 = match.getRange().getLast() + 1;
                replacingChars.addReplacement(new IntRange(n2, match.getRange().getLast() + 1), Space.INSTANCE);
            }
            replacingChars.commit();
        }
        $i$f$forEach = false;
        ArrayList mappedWords = new ArrayList();
        Function1<IntRange, Unit> $fun$addMappedWords$3 = new Function1<IntRange, Unit>(mappedWords, textLine, makeWord){
            final /* synthetic */ ArrayList $mappedWords;
            final /* synthetic */ CharSequence $textLine;
            final /* synthetic */ Function1 $makeWord;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull IntRange originalRange) {
                List list;
                void $this$zipWithNext$iv;
                Object list$iv$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Intrinsics.checkNotNullParameter(originalRange, "originalRange");
                if (originalRange.isEmpty()) {
                    return;
                }
                Iterable iterable = StringsKt.split$default(StringsKt.subSequence(this.$textLine, originalRange), new char[]{' '}, false, 0, 6, null);
                ArrayList arrayList = this.$mappedWords;
                boolean $i$f$flatMap = false;
                void var4_5 = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    String word = (String)element$iv$iv;
                    boolean bl = false;
                    list$iv$iv = CollectionsKt.listOfNotNull(this.$makeWord.invoke(word));
                    CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
                }
                List list2 = (List)destination$iv$iv2;
                $this$flatMap$iv = CollectionsKt.plus((Collection)list2, Space.INSTANCE);
                boolean $i$f$zipWithNext = false;
                Iterator<T> iterator$iv = $this$zipWithNext$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    list = CollectionsKt.emptyList();
                } else {
                    boolean destination$iv$iv2 = false;
                    List result$iv = new ArrayList<E>();
                    T current$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void right;
                        void left;
                        Object element$iv$iv;
                        T next$iv = iterator$iv.next();
                        element$iv$iv = (InlineElement)next$iv;
                        list$iv$iv = (InlineElement)current$iv;
                        list2 = result$iv;
                        boolean bl = false;
                        List<void> list3 = left instanceof Word && right instanceof Word ? CollectionsKt.listOf(left, Space.INSTANCE) : CollectionsKt.listOf(left);
                        list2.add(list3);
                        current$iv = next$iv;
                    }
                    list = result$iv;
                }
                list2 = list;
                arrayList.addAll((Collection)CollectionsKt.flatten(list2));
            }
            {
                this.$mappedWords = arrayList;
                this.$textLine = charSequence;
                this.$makeWord = function1;
                super(1);
            }
        };
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        replacingChars.forEachReplace((Function1<? super Pair<IntRange, ? extends InlineElement>, Unit>)new Function1<Pair<? extends IntRange, ? extends InlineElement>, Unit>($fun$addMappedWords$3, (Ref.IntRef)startIdx, mappedWords){
            final /* synthetic */ splitSpacesAndWords.3 $addMappedWords$3;
            final /* synthetic */ Ref.IntRef $startIdx;
            final /* synthetic */ ArrayList $mappedWords;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Pair<IntRange, ? extends InlineElement> $dstr$range$inlineElem) {
                void range;
                Intrinsics.checkNotNullParameter($dstr$range$inlineElem, "<name for destructuring parameter 0>");
                IntRange intRange = $dstr$range$inlineElem.component1();
                InlineElement inlineElem = $dstr$range$inlineElem.component2();
                this.$addMappedWords$3.invoke(RangesKt.until(this.$startIdx.element, range.getFirst()));
                this.$mappedWords.add(inlineElem);
                this.$startIdx.element = range.getLast() + 1;
            }
            {
                this.$addMappedWords$3 = var1_1;
                this.$startIdx = intRef;
                this.$mappedWords = arrayList;
                super(1);
            }
        });
        int n = startIdx.element;
        $fun$addMappedWords$3.invoke(new IntRange(n, StringsKt.getLastIndex(replacingChars.getOriginal())));
        return mappedWords;
    }

    public static /* synthetic */ List splitSpacesAndWords$logisticspipes$default(MarkdownParser markdownParser, CharSequence charSequence, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = new Function1<String, Word>(markdownParser){

                @Nullable
                public final Word invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    return MarkdownParser.access$parseTextElement((MarkdownParser)this.receiver, p1);
                }
            };
        }
        return markdownParser.splitSpacesAndWords$logisticspipes(charSequence, function1);
    }

    private final Word parseTextElement(String word) {
        CharSequence charSequence = word;
        boolean bl = false;
        return !StringsKt.isBlank(charSequence) ? new Word(word) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlineElement> parseLinks(CharSequence inputChars, Function2<? super CharSequence, ? super Function1<? super String, ? extends Word>, ? extends List<? extends InlineElement>> splitSpacesAndWords2, Function1<? super CharSequence, ? extends List<? extends InlineElement>> splitWhitespaceCharactersAndWords) {
        void lastCharLookedAt;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Function0 postfixGetter2 = new Function0<CharSequence>((Ref.IntRef)lastCharLookedAt, inputChars){
            final /* synthetic */ Ref.IntRef $lastCharLookedAt;
            final /* synthetic */ CharSequence $inputChars;

            @NotNull
            public final CharSequence invoke() {
                return this.$lastCharLookedAt.element < this.$inputChars.length() ? this.$inputChars.subSequence(this.$lastCharLookedAt.element, this.$inputChars.length()) : (CharSequence)"";
            }
            {
                this.$lastCharLookedAt = intRef;
                this.$inputChars = charSequence;
                super(0);
            }
        };
        Function0 isLastWhitespace2 = new Function0<Boolean>(inputChars, (Ref.IntRef)lastCharLookedAt){
            final /* synthetic */ CharSequence $inputChars;
            final /* synthetic */ Ref.IntRef $lastCharLookedAt;

            public final boolean invoke() {
                int n = this.$lastCharLookedAt.element;
                return 1 <= n && this.$inputChars.length() > n && CharsKt.isWhitespace(this.$inputChars.charAt(this.$lastCharLookedAt.element));
            }
            {
                this.$inputChars = charSequence;
                this.$lastCharLookedAt = intRef;
                super(0);
            }
        };
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)SequencesKt.toList(SequencesKt.flatMapIterable(SequencesKt.map(Regex.findAll$default(linkRegex, inputChars, 0, 2, null), parseLinks.1.INSTANCE), (Function1)new Function1<LinkMatcher, List<? extends InlineElement>>(inputChars, (Ref.IntRef)lastCharLookedAt, splitWhitespaceCharactersAndWords, isLastWhitespace2, splitSpacesAndWords2){
            final /* synthetic */ CharSequence $inputChars;
            final /* synthetic */ Ref.IntRef $lastCharLookedAt;
            final /* synthetic */ Function1 $splitWhitespaceCharactersAndWords;
            final /* synthetic */ Function0 $isLastWhitespace;
            final /* synthetic */ Function2 $splitSpacesAndWords;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<InlineElement> invoke(@NotNull LinkMatcher link) {
                List<T> list;
                List[] listArray;
                R it;
                boolean bl;
                boolean bl2;
                Object object;
                block8: {
                    block7: {
                        void linkRef;
                        List[] listArray2;
                        Object object2;
                        List<T> list2;
                        List[] listArray3;
                        Intrinsics.checkNotNullParameter(link, "link");
                        CharSequence before = this.$inputChars.subSequence(this.$lastCharLookedAt.element, link.getMatch().getRange().getFirst());
                        object = this.$splitWhitespaceCharactersAndWords.invoke(before);
                        bl2 = false;
                        bl = false;
                        List list3 = (List)object;
                        int n = 0;
                        List[] listArray4 = listArray3 = new List[2];
                        boolean bl3 = false;
                        listArray3[n] = list2 = (Boolean)this.$isLastWhitespace.invoke() == false && it.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.plus((Collection)it, (Iterable)CollectionsKt.listOf(Space.INSTANCE));
                        List[] listArray5 = listArray4;
                        listArray = listArray4;
                        int n2 = 1;
                        if (link.isPageLink()) {
                            String string = link.getLinkWithoutProtocol();
                            Intrinsics.checkNotNull(string);
                            object2 = new PageLink(string);
                        } else if (link.isWebLink()) {
                            String string = link.getLink();
                            Intrinsics.checkNotNull(string);
                            object2 = new WebLink(string);
                        } else {
                            object2 = list = null;
                        }
                        if (object2 == null) break block7;
                        object = list;
                        bl2 = false;
                        bl = false;
                        it = object;
                        n = n2;
                        listArray3 = listArray5;
                        listArray4 = listArray;
                        boolean bl4 = false;
                        Word word = new Word("!");
                        boolean bl5 = false;
                        boolean bl6 = false;
                        Word word2 = word;
                        int n3 = 0;
                        List[] listArray6 = listArray2 = new List[2];
                        boolean bl7 = false;
                        boolean bl8 = link.getImageLinkFlag();
                        listArray2[n3] = CollectionsKt.listOfNotNull(bl8 ? word : null);
                        String string = link.getText();
                        Intrinsics.checkNotNull(string);
                        listArray6[1] = (List)this.$splitSpacesAndWords.invoke(string, new Function1<String, Word>((Link)linkRef){
                            final /* synthetic */ Link $linkRef;

                            @Nullable
                            public final Word invoke(@NotNull String word) {
                                Intrinsics.checkNotNullParameter(word, "word");
                                CharSequence charSequence = word;
                                boolean bl = false;
                                return !StringsKt.isBlank(charSequence) ? (Word)new LinkWord(word, this.$linkRef) : null;
                            }
                            {
                                this.$linkRef = link;
                                super(1);
                            }
                        });
                        list2 = CollectionsKt.flatten((Iterable)CollectionsKt.listOf(listArray6));
                        listArray = listArray4;
                        listArray5 = listArray3;
                        n2 = n;
                        list = list2;
                        if (list != null) break block8;
                    }
                    list = (List)this.$splitWhitespaceCharactersAndWords.invoke(link.getMatch().getValue());
                }
                listArray5[n2] = list;
                object = CollectionsKt.flatten((Iterable)CollectionsKt.listOf(listArray));
                bl2 = false;
                bl = false;
                it = object;
                boolean bl9 = false;
                this.$lastCharLookedAt.element = link.getMatch().getRange().getLast() + 1;
                return object;
            }
            {
                this.$inputChars = charSequence;
                this.$lastCharLookedAt = intRef;
                this.$splitWhitespaceCharactersAndWords = function1;
                this.$isLastWhitespace = function0;
                this.$splitSpacesAndWords = function2;
                super(1);
            }
        })), (Iterable)((Boolean)isLastWhitespace2.invoke() != false ? CollectionsKt.listOf(Space.INSTANCE) : CollectionsKt.emptyList())), (Iterable)splitWhitespaceCharactersAndWords.invoke((CharSequence)postfixGetter2.invoke()));
    }

    private final int countChars(char c, String str, int index, int maximum) {
        int count2;
        if (str.charAt(index) != c) {
            return 0;
        }
        int actualMax = Integer.min(str.length() - index, maximum);
        for (count2 = 1; count2 < actualMax && str.charAt(index + count2) == c; ++count2) {
        }
        return count2;
    }

    static /* synthetic */ int countChars$default(MarkdownParser markdownParser, char c, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = string.length();
        }
        return markdownParser.countChars(c, string, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Paragraph> parseParagraphs(@NotNull String str) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(str, "str");
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>();
        StringBuilder sb = new StringBuilder();
        List lines = StringsKt.split$default((CharSequence)str, new char[]{'\n'}, false, 0, 6, null);
        Function0<Unit> $fun$completeParagraph$1 = new Function0<Unit>(sb, paragraphs){
            final /* synthetic */ StringBuilder $sb;
            final /* synthetic */ ArrayList $paragraphs;

            public final void invoke() {
                CharSequence charSequence = this.$sb;
                boolean bl = false;
                if (!StringsKt.isBlank(charSequence)) {
                    List parsedInlineElements2 = MarkdownParser.access$parseLinks(MarkdownParser.INSTANCE, this.$sb, new Function2<CharSequence, Function1<? super String, ? extends Word>, List<? extends InlineElement>>(MarkdownParser.INSTANCE){

                        @NotNull
                        public final List<InlineElement> invoke(@NotNull CharSequence p1, @NotNull Function1<? super String, ? extends Word> p2) {
                            Intrinsics.checkNotNullParameter(p1, "p1");
                            Intrinsics.checkNotNullParameter(p2, "p2");
                            return ((MarkdownParser)this.receiver).splitSpacesAndWords$logisticspipes(p1, p2);
                        }
                    }, new Function1<CharSequence, List<? extends InlineElement>>(MarkdownParser.INSTANCE){

                        @NotNull
                        public final List<InlineElement> invoke(@NotNull CharSequence p1) {
                            Intrinsics.checkNotNullParameter(p1, "p1");
                            return ((MarkdownParser)this.receiver).splitWhitespaceCharactersAndWords$logisticspipes(p1);
                        }
                    });
                    this.$paragraphs.add(new RegularParagraph(parsedInlineElements2));
                }
                StringsKt.clear(this.$sb);
            }
            {
                this.$sb = stringBuilder;
                this.$paragraphs = arrayList;
                super(0);
            }
        };
        Iterable $this$flatMap$iv = lines;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String line = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.bufferOrReturnLine(line, sb);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv$iv;
            String dirtyLine = (String)element$iv;
            boolean bl = false;
            element$iv$iv = dirtyLine;
            boolean list$iv$iv = false;
            Object object = element$iv$iv;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String line = ((Object)StringsKt.trimStart((CharSequence)object)).toString();
            Function0<Unit> $fun$dumpLineToBuffer$1 = new Function0<Unit>(line, sb, $fun$completeParagraph$1, paragraphs){
                final /* synthetic */ String $line;
                final /* synthetic */ StringBuilder $sb$inlined;
                final /* synthetic */ parseParagraphs.1 $completeParagraph$1$inlined;
                final /* synthetic */ ArrayList $paragraphs$inlined;
                {
                    this.$line = string;
                    this.$sb$inlined = stringBuilder;
                    this.$completeParagraph$1$inlined = var3_3;
                    this.$paragraphs$inlined = arrayList;
                    super(0);
                }

                public final void invoke() {
                    CharSequence charSequence = this.$sb$inlined;
                    boolean bl = false;
                    if (charSequence.length() > 0) {
                        this.$sb$inlined.append(' ');
                    }
                    this.$sb$inlined.append(this.$line);
                }
            };
            Object var15_19 = null;
            Lazy lineLinkMatch2 = LazyKt.lazy((Function0)new Function0<LinkMatcher>(line){
                final /* synthetic */ String $line;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final LinkMatcher invoke() {
                    MatchResult matchResult = Regex.find$default(MarkdownParser.access$getLinkRegex$p(MarkdownParser.INSTANCE), this.$line, 0, 2, null);
                    MatchResult matchResult2 = matchResult;
                    if (matchResult == null) return null;
                    MatchResult matchResult3 = matchResult2;
                    boolean bl = false;
                    boolean bl2 = false;
                    MatchResult it = matchResult3;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getValue(), this.$line)) return null;
                    MatchResult matchResult4 = matchResult3;
                    matchResult2 = matchResult4;
                    if (matchResult4 == null) return null;
                    matchResult3 = matchResult2;
                    bl = false;
                    bl2 = false;
                    it = matchResult3;
                    boolean bl4 = false;
                    LinkMatcher linkMatcher = new LinkMatcher(it);
                    return linkMatcher;
                }
                {
                    this.$line = string;
                    super(0);
                }
            });
            Lazy lazy = line;
            boolean bl2 = false;
            if (lazy.length() == 0) {
                $fun$completeParagraph$1.invoke();
                continue;
            }
            if (StringsKt.startsWith$default((CharSequence)line, '#', false, 2, null)) {
                int charCount = MarkdownParser.countChars$default(INSTANCE, '#', line, 0, 6, 4, null);
                String text = StringsKt.trimStart(line, '#');
                if (StringsKt.isBlank(text)) {
                    $fun$dumpLineToBuffer$1.invoke();
                    continue;
                }
                if (text.charAt(0) == ' ') {
                    $fun$completeParagraph$1.invoke();
                    paragraphs.add(new HeaderParagraph(INSTANCE.splitWhitespaceCharactersAndWords$logisticspipes(StringsKt.trimEnd(text, '#')), charCount));
                    continue;
                }
                $fun$dumpLineToBuffer$1.invoke();
                continue;
            }
            if (StringsKt.startsWith$default(line, "===", false, 2, null)) {
                Paragraph paragraph;
                if (StringsKt.isBlank(sb)) {
                    paragraph = HorizontalLineParagraph.INSTANCE;
                } else {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
                    paragraph = new HeaderParagraph(INSTANCE.splitWhitespaceCharactersAndWords$logisticspipes(string), 1);
                }
                paragraphs.add(paragraph);
                StringsKt.clear(sb);
                continue;
            }
            if (StringsKt.startsWith$default(line, "---", false, 2, null)) {
                Paragraph paragraph;
                if (StringsKt.isBlank(sb)) {
                    paragraph = HorizontalLineParagraph.INSTANCE;
                } else {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
                    paragraph = new HeaderParagraph(INSTANCE.splitWhitespaceCharactersAndWords$logisticspipes(string), 2);
                }
                paragraphs.add(paragraph);
                StringsKt.clear(sb);
                continue;
            }
            lazy = lineLinkMatch2;
            Object var17_24 = null;
            boolean bl3 = false;
            LinkMatcher linkMatcher = (LinkMatcher)lazy.getValue();
            if (linkMatcher != null) {
                if (linkMatcher.isMenuLink()) {
                    lazy = lineLinkMatch2;
                    var17_24 = null;
                    bl3 = false;
                    LinkMatcher linkMatcher2 = (LinkMatcher)lazy.getValue();
                    Intrinsics.checkNotNull(linkMatcher2);
                    if (!linkMatcher2.getImageLinkFlag()) {
                        $fun$completeParagraph$1.invoke();
                        lazy = lineLinkMatch2;
                        var17_24 = null;
                        bl3 = false;
                        LinkMatcher linkMatcher3 = (LinkMatcher)lazy.getValue();
                        Intrinsics.checkNotNull(linkMatcher3);
                        String string = linkMatcher3.getText();
                        Intrinsics.checkNotNull(string);
                        lazy = lineLinkMatch2;
                        var17_24 = null;
                        bl3 = false;
                        LinkMatcher linkMatcher4 = (LinkMatcher)lazy.getValue();
                        Intrinsics.checkNotNull(linkMatcher4);
                        String string2 = linkMatcher4.getLinkWithoutProtocol();
                        Intrinsics.checkNotNull(string2);
                        paragraphs.add(new MenuParagraph(string, string2));
                        continue;
                    }
                }
            }
            lazy = lineLinkMatch2;
            var17_24 = null;
            bl3 = false;
            LinkMatcher linkMatcher5 = (LinkMatcher)lazy.getValue();
            if (linkMatcher5 != null) {
                if (linkMatcher5.isImageLink()) {
                    lazy = lineLinkMatch2;
                    var17_24 = null;
                    bl3 = false;
                    LinkMatcher linkMatcher6 = (LinkMatcher)lazy.getValue();
                    Intrinsics.checkNotNull(linkMatcher6);
                    if (linkMatcher6.getImageLinkFlag()) {
                        $fun$completeParagraph$1.invoke();
                        lazy = lineLinkMatch2;
                        var17_24 = null;
                        bl3 = false;
                        LinkMatcher linkMatcher7 = (LinkMatcher)lazy.getValue();
                        Intrinsics.checkNotNull(linkMatcher7);
                        String string = linkMatcher7.getText();
                        Intrinsics.checkNotNull(string);
                        lazy = lineLinkMatch2;
                        var17_24 = null;
                        bl3 = false;
                        LinkMatcher linkMatcher8 = (LinkMatcher)lazy.getValue();
                        Intrinsics.checkNotNull(linkMatcher8);
                        String string3 = linkMatcher8.getLinkWithoutProtocol();
                        Intrinsics.checkNotNull(string3);
                        paragraphs.add(new ImageParagraph(string, string3));
                        continue;
                    }
                }
            }
            $fun$dumpLineToBuffer$1.invoke();
        }
        $fun$completeParagraph$1.invoke();
        return paragraphs;
    }

    private final List<String> bufferOrReturnLine(String line, StringBuilder buffer) {
        if (StringsKt.endsWith$default((CharSequence)line, '\\', false, 2, null)) {
            String string = line;
            int n = 0;
            int n2 = line.length() - 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            buffer.append(string3);
            return CollectionsKt.emptyList();
        }
        if (StringsKt.endsWith$default(line, "  ", false, 2, null)) {
            String string = line;
            int n = 0;
            int n3 = line.length() - 2;
            boolean bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            buffer.append(string5);
            buffer.append('\n');
        } else {
            buffer.append(line);
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "buffer.toString()");
        String concatLine = string;
        StringsKt.clear(buffer);
        return CollectionsKt.listOf(concatLine);
    }

    private MarkdownParser() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        MarkdownParser markdownParser;
        INSTANCE = markdownParser = new MarkdownParser();
        linkRegex = new Regex("!?\\[(.+?)]\\((.+?)\\)");
        webLinkRegex = new Regex("^https?://", RegexOption.IGNORE_CASE);
        Iterable $this$flatMap$iv = RangesKt.downTo(3, 1);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            int element$iv$iv;
            int times = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable $this$map$iv2 = CollectionsKt.listOf("_", "\\*");
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Pair<Integer, String> pair = TuplesKt.to(times, StringsKt.repeat((CharSequence)it, times));
                collection.add(pair);
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void times;
            void $dstr$times$formatChain;
            list$iv$iv = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int $this$map$iv2 = ((Number)$dstr$times$formatChain.component1()).intValue();
            String formatChain = (String)$dstr$times$formatChain.component2();
            Pair<Integer, Regex> pair = TuplesKt.to((int)times, new Regex("(?!\\\\)" + formatChain + "(.+?)(?!\\\\)" + formatChain));
            collection.add(pair);
        }
        boldItalicRegexes = (List)destination$iv$iv;
        htmlBreakRegex = new Regex("<br(\\s*/)?>");
    }

    public static final /* synthetic */ Regex access$getWebLinkRegex$p(MarkdownParser $this) {
        MarkdownParser markdownParser = $this;
        return webLinkRegex;
    }

    public static final /* synthetic */ Word access$parseTextElement(MarkdownParser $this, String word) {
        return $this.parseTextElement(word);
    }

    public static final /* synthetic */ List access$parseLinks(MarkdownParser $this, CharSequence inputChars, Function2 splitSpacesAndWords2, Function1 splitWhitespaceCharactersAndWords) {
        return $this.parseLinks(inputChars, splitSpacesAndWords2, splitWhitespaceCharactersAndWords);
    }

    public static final /* synthetic */ Regex access$getLinkRegex$p(MarkdownParser $this) {
        MarkdownParser markdownParser = $this;
        return linkRegex;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0017"}, d2={"Lnetwork/rs485/markdown/MarkdownParser$LinkMatcher;", "", "match", "Llogisticspipes/kotlin/text/MatchResult;", "(Lkotlin/text/MatchResult;)V", "imageLinkFlag", "", "getImageLinkFlag", "()Z", "link", "", "getLink", "()Ljava/lang/String;", "linkWithoutProtocol", "getLinkWithoutProtocol", "getMatch", "()Lkotlin/text/MatchResult;", "text", "getText", "isImageLink", "isMenuLink", "isPageLink", "isWebLink", "logisticspipes"})
    private static final class LinkMatcher {
        @NotNull
        private final MatchResult match;

        @Nullable
        public final String getText() {
            MatchGroup matchGroup = this.match.getGroups().get(1);
            return matchGroup != null ? matchGroup.getValue() : null;
        }

        @Nullable
        public final String getLink() {
            MatchGroup matchGroup = this.match.getGroups().get(2);
            return matchGroup != null ? matchGroup.getValue() : null;
        }

        @Nullable
        public final String getLinkWithoutProtocol() {
            String string;
            String string2 = this.getLink();
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String $this$run = string3;
                boolean bl3 = false;
                String string4 = $this$run;
                int n = StringsKt.indexOf$default((CharSequence)$this$run, "://", 0, false, 6, null) + 3;
                boolean bl4 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n);
                string = string6;
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).substring(startIndex)");
            } else {
                string = null;
            }
            return string;
        }

        public final boolean getImageLinkFlag() {
            String string = this.match.getValue();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), '!', false, 2, null);
        }

        public final boolean isMenuLink() {
            String string = this.getLink();
            return string != null ? StringsKt.startsWith(string, "menu://", true) : false;
        }

        public final boolean isPageLink() {
            String string = this.getLink();
            return string != null ? StringsKt.startsWith(string, "page://", true) : false;
        }

        public final boolean isWebLink() {
            boolean bl;
            String string = this.getLink();
            if (string != null) {
                CharSequence charSequence = string;
                Regex regex = MarkdownParser.access$getWebLinkRegex$p(INSTANCE);
                boolean bl2 = false;
                bl = regex.matches(charSequence);
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean isImageLink() {
            String string = this.getLink();
            return string != null ? StringsKt.startsWith(string, "image://", true) : false;
        }

        @NotNull
        public final MatchResult getMatch() {
            return this.match;
        }

        public LinkMatcher(@NotNull MatchResult match) {
            Intrinsics.checkNotNullParameter(match, "match");
            this.match = match;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0006\u0010 \u001a\u00020\u001aJ\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J&\u0010%\u001a\u00020\u001a2\u001e\u0010&\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u000b\u0012\u0004\u0012\u00020\u001a0'J\u0011\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\fH\u0096\u0002J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001b\u001a\u00020\u0015J\b\u0010,\u001a\u00020\fH\u0016J\u0018\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\fH\u0016J\b\u00100\u001a\u00020\u0005H\u0016J\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00102\u001a\u00020\fH\u0002J\b\u00103\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00180\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lnetwork/rs485/markdown/MarkdownParser$ReplacedCharSequence;", "", "original", "(Ljava/lang/CharSequence;)V", "cache", "", "current", "getCurrent", "()Ljava/lang/String;", "formattingStart", "", "Llogisticspipes/kotlin/Pair;", "", "Ljava/util/EnumSet;", "Lnetwork/rs485/markdown/TextFormat;", "length", "getLength", "()I", "getOriginal", "()Ljava/lang/CharSequence;", "replacementMap", "Llogisticspipes/kotlin/ranges/IntRange;", "Lnetwork/rs485/markdown/InlineElement;", "stagingReplacementMap", "Llogisticspipes/kotlin/Triple;", "addReplacement", "", "range", "element", "chars", "Ljava/util/stream/IntStream;", "codePoints", "commit", "equals", "", "other", "", "forEachReplace", "action", "Llogisticspipes/kotlin/Function1;", "get", "", "index", "getFormatting", "hashCode", "subSequence", "startIndex", "endIndex", "toString", "translateIndex", "start", "updateCachedSequence", "logisticspipes"})
    public static final class ReplacedCharSequence
    implements CharSequence {
        private final List<Pair<Integer, EnumSet<TextFormat>>> formattingStart;
        private final List<Pair<IntRange, InlineElement>> replacementMap;
        private final List<Triple<Integer, IntRange, InlineElement>> stagingReplacementMap;
        private String cache;
        @NotNull
        private final CharSequence original;

        @NotNull
        public final String getCurrent() {
            String string = this.cache;
            if (string == null) {
                string = this.updateCachedSequence();
            }
            return string;
        }

        private final String updateCachedSequence() {
            StringBuilder sb = new StringBuilder();
            Function1 append2 = new Function1<IntRange, IntRange>(this, sb){
                final /* synthetic */ ReplacedCharSequence this$0;
                final /* synthetic */ StringBuilder $sb;

                @Nullable
                public final IntRange invoke(@NotNull IntRange range) {
                    IntRange intRange;
                    Intrinsics.checkNotNullParameter(range, "range");
                    IntRange intRange2 = range;
                    boolean bl = false;
                    boolean bl2 = false;
                    IntRange it = intRange2;
                    boolean bl3 = false;
                    IntRange intRange3 = !it.isEmpty() ? intRange2 : null;
                    if (intRange3 != null) {
                        intRange2 = intRange3;
                        bl = false;
                        bl2 = false;
                        it = intRange2;
                        boolean bl4 = false;
                        this.$sb.append(StringsKt.subSequence(this.this$0.getOriginal(), it));
                        intRange = intRange2;
                    } else {
                        intRange = null;
                    }
                    return intRange;
                }
                {
                    this.this$0 = replacedCharSequence;
                    this.$sb = stringBuilder;
                    super(1);
                }
            };
            int lastIdx = 0;
            Iterable $this$forEach$iv = this.replacementMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair $dstr$range$_u24__u24 = (Pair)element$iv;
                boolean bl = false;
                IntRange range = (IntRange)$dstr$range$_u24__u24.component1();
                boolean bl2 = range.getFirst() >= lastIdx;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string = "trying to replace already replaced index " + lastIdx + " in " + this.replacementMap;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                append2.invoke(RangesKt.until(lastIdx, range.getFirst()));
                lastIdx = range.getLast() + 1;
            }
            append2.invoke(RangesKt.until(lastIdx, this.original.length()));
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
            String string2 = string;
            boolean bl = false;
            boolean bl5 = false;
            String it = string2;
            boolean bl6 = false;
            this.cache = it;
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        public final void addReplacement(@NotNull IntRange range, @NotNull InlineElement element) {
            void replacementMapIdx;
            int translatedIdx;
            Intrinsics.checkNotNullParameter(range, "range");
            Intrinsics.checkNotNullParameter(element, "element");
            Pair<Integer, Integer> pair = this.translateIndex(range.getFirst());
            int n = ((Number)pair.component1()).intValue();
            int n2 = translatedIdx = ((Number)pair.component2()).intValue();
            this.stagingReplacementMap.add(new Triple<Integer, IntRange, InlineElement>((int)(replacementMapIdx + true), new IntRange(n2, range.getLast() + translatedIdx - range.getFirst()), element));
            if (element instanceof TextFormatting) {
                Pair<Integer, EnumSet<TextFormat>> newFormat = TuplesKt.to(translatedIdx, ((TextFormatting)element).getFormat());
                if (this.formattingStart.isEmpty()) {
                    this.formattingStart.add(newFormat);
                } else {
                    int formatIdx2 = CollectionsKt.binarySearch$default(this.formattingStart, newFormat, addReplacement.formatIdx.1.INSTANCE, 0, 0, 12, null);
                    if (formatIdx2 < 0) {
                        this.formattingStart.add(-formatIdx2 - 1, newFormat);
                    } else if (Intrinsics.areEqual(this.formattingStart.get(formatIdx2).getSecond(), newFormat.getSecond()) ^ true) {
                        this.formattingStart.add(formatIdx2 + 1, newFormat);
                    }
                }
            }
        }

        @NotNull
        public final EnumSet<TextFormat> getFormatting(@NotNull IntRange range) {
            Intrinsics.checkNotNullParameter(range, "range");
            if (this.formattingStart.isEmpty()) {
                return TextFormat.Companion.getNone();
            }
            Pair<Integer, Integer> pair = this.translateIndex(range.getFirst());
            int translatedIdx = ((Number)pair.component2()).intValue();
            int formatIdx2 = CollectionsKt.binarySearch$default(this.formattingStart, TuplesKt.to(translatedIdx, null), getFormatting.formatIdx.1.INSTANCE, 0, 0, 12, null);
            return formatIdx2 == -1 ? TextFormat.Companion.getNone() : (formatIdx2 < -1 ? this.formattingStart.get(-formatIdx2 - 2).getSecond() : this.formattingStart.get(formatIdx2).getSecond());
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> translateIndex(int start) {
            void translatedIdx;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = start;
            int replacementMapIdx = -1;
            Sequence $this$forEachIndexed$iv = SequencesKt.takeWhile(CollectionsKt.asSequence((Iterable)this.replacementMap), (Function1)new Function1<Pair<? extends IntRange, ? extends InlineElement>, Boolean>((Ref.IntRef)translatedIdx){
                final /* synthetic */ Ref.IntRef $translatedIdx;

                public final boolean invoke(@NotNull Pair<IntRange, ? extends InlineElement> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$translatedIdx.element >= it.getFirst().getFirst();
                }
                {
                    this.$translatedIdx = intRef;
                    super(1);
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            Iterator iterator2 = $this$forEachIndexed$iv.iterator();
            while (iterator2.hasNext()) {
                void $dstr$range$_u24__u24;
                Object item$iv = iterator2.next();
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int curry = n;
                boolean bl2 = false;
                IntRange range = (IntRange)$dstr$range$_u24__u24.component1();
                translatedIdx.element += CollectionsKt.count(range);
                replacementMapIdx = curry;
            }
            return TuplesKt.to(replacementMapIdx, translatedIdx.element);
        }

        public final void commit() {
            Collection collection = this.stagingReplacementMap;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)this.stagingReplacementMap);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Triple it = (Triple)element$iv;
                    boolean bl2 = false;
                    this.replacementMap.add(((Number)it.getFirst()).intValue(), TuplesKt.to(it.getSecond(), it.getThird()));
                }
                this.cache = null;
                this.stagingReplacementMap.clear();
            }
        }

        public final void forEachReplace(@NotNull Function1<? super Pair<IntRange, ? extends InlineElement>, Unit> action) {
            Intrinsics.checkNotNullParameter(action, "action");
            Iterable $this$forEach$iv = this.replacementMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke((Pair<IntRange, ? extends InlineElement>)element$iv);
            }
        }

        public int getLength() {
            return this.getCurrent().length();
        }

        public char get(int index) {
            return this.getCurrent().charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int startIndex, int endIndex) {
            return this.getCurrent().subSequence(startIndex, endIndex);
        }

        @Override
        @NotNull
        public IntStream chars() {
            IntStream intStream = this.getCurrent().chars();
            Intrinsics.checkNotNullExpressionValue(intStream, "current.chars()");
            return intStream;
        }

        @Override
        @NotNull
        public IntStream codePoints() {
            IntStream intStream = this.getCurrent().codePoints();
            Intrinsics.checkNotNullExpressionValue(intStream, "current.codePoints()");
            return intStream;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ReplacedCharSequence && Intrinsics.areEqual(this.original, ((ReplacedCharSequence)other).original) && Intrinsics.areEqual(this.replacementMap, ((ReplacedCharSequence)other).replacementMap);
        }

        public int hashCode() {
            return this.original.hashCode() + ((Object)this.replacementMap).hashCode();
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + "(original=\"" + StringsKt.take(this.original, 16) + "[\u2026]\"," + "replacementMap=" + StringsKt.take(this.replacementMap.toString(), 16) + "[\u2026])";
        }

        @NotNull
        public final CharSequence getOriginal() {
            return this.original;
        }

        public ReplacedCharSequence(@NotNull CharSequence original) {
            Intrinsics.checkNotNullParameter(original, "original");
            this.original = original;
            boolean bl = false;
            this.formattingStart = new ArrayList();
            bl = false;
            this.replacementMap = new ArrayList();
            bl = false;
            this.stagingReplacementMap = new ArrayList();
        }
    }
}

