/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.world;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import network.rs485.logisticspipes.connection.NeighborTileEntity;

public class WorldCoordinatesWrapper {
    @Nonnull
    private final World world;
    @Nonnull
    private final BlockPos pos;

    public WorldCoordinatesWrapper(@Nonnull World world, @Nonnull BlockPos pos) {
        Objects.requireNonNull(world, "World must not be null");
        Objects.requireNonNull(pos, "Position must not be null");
        this.world = world;
        this.pos = pos;
    }

    public WorldCoordinatesWrapper(TileEntity tileEntity) {
        this(tileEntity.func_145831_w(), tileEntity.func_174877_v());
    }

    public Stream<NeighborTileEntity<TileEntity>> allNeighborTileEntities() {
        return Arrays.stream(EnumFacing.field_82609_l).map(this::getNeighbor).filter(Objects::nonNull);
    }

    public Stream<NeighborTileEntity<TileEntity>> connectedTileEntities() {
        TileEntity pipe = this.getTileEntity();
        if (SimpleServiceLocator.pipeInformationManager.isNotAPipe(pipe)) {
            LogisticsPipes.log.warn("The coordinates didn't hold a pipe at all", new Throwable("Stack trace"));
            return Stream.empty();
        }
        return this.allNeighborTileEntities().filter(adjacent -> MainProxy.checkPipesConnections(pipe, adjacent.getTileEntity(), adjacent.getDirection()));
    }

    public Stream<NeighborTileEntity<TileEntity>> connectedTileEntities(IPipeInformationProvider.ConnectionPipeType pipeType) {
        TileEntity pipe = this.getTileEntity();
        if (!SimpleServiceLocator.pipeInformationManager.isPipe(pipe, true, pipeType)) {
            if (LogisticsPipes.isDEBUG()) {
                LogisticsPipes.log.warn("The coordinates didn't hold the pipe type " + (Object)((Object)pipeType), new Throwable("Stack trace"));
            }
            return Stream.empty();
        }
        return this.allNeighborTileEntities().filter(neighbor -> MainProxy.checkPipesConnections(pipe, neighbor.getTileEntity(), neighbor.getDirection()));
    }

    @Nullable
    public TileEntity getTileEntity() {
        return this.world.func_175625_s(this.pos);
    }

    @Nullable
    public NeighborTileEntity<TileEntity> getNeighbor(@Nonnull EnumFacing direction) {
        TileEntity tileEntity = this.world.func_175625_s(this.pos.func_177972_a(direction));
        if (tileEntity == null) {
            return null;
        }
        return new NeighborTileEntity<TileEntity>(tileEntity, direction);
    }

    @Nonnull
    public World getWorld() {
        return this.world;
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorldCoordinatesWrapper)) {
            return false;
        }
        WorldCoordinatesWrapper other = (WorldCoordinatesWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorldCoordinatesWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        World $world = this.getWorld();
        result2 = result2 * 59 + ($world == null ? 43 : $world.hashCode());
        BlockPos $pos = this.getPos();
        result2 = result2 * 59 + ($pos == null ? 43 : $pos.hashCode());
        return result2;
    }

    public String toString() {
        return "WorldCoordinatesWrapper(world=" + this.getWorld() + ", pos=" + this.getPos() + ")";
    }
}

