/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.connection;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import network.rs485.logisticspipes.connection.NeighborTileEntitySneakyInsertion;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u0000\"\n\b\u0001\u0010\u000e\u0018\u0001*\u00028\u0000H\u0086\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J*\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00000\u0012\"\b\b\u0001\u0010\u000e*\u00028\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0014J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0007J\u0012\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aJ\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u0018J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lnetwork/rs485/logisticspipes/connection/NeighborTileEntity;", "T", "Lnet/minecraft/tileentity/TileEntity;", "", "tileEntity", "direction", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/util/EnumFacing;)V", "getDirection", "()Lnet/minecraft/util/EnumFacing;", "getTileEntity", "()Lnet/minecraft/tileentity/TileEntity;", "Lnet/minecraft/tileentity/TileEntity;", "getInstanceOf", "C", "getInventoryUtil", "Llogisticspipes/interfaces/IInventoryUtil;", "getJavaInstanceOf", "Ljava/util/Optional;", "clazz", "Ljava/lang/Class;", "getOurDirection", "getUtilForItemHandler", "hasCapability", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "isItemHandler", "isLogisticsPipe", "sneakyInsertion", "Lnetwork/rs485/logisticspipes/connection/NeighborTileEntitySneakyInsertion;", "logisticspipes"})
public class NeighborTileEntity<T extends TileEntity> {
    @NotNull
    private final T tileEntity;
    @NotNull
    private final EnumFacing direction;

    @NotNull
    public EnumFacing getOurDirection() {
        EnumFacing enumFacing = this.direction.func_176734_d();
        Intrinsics.checkNotNullExpressionValue(enumFacing, "direction.opposite");
        return enumFacing;
    }

    public final boolean hasCapability(@NotNull Capability<?> capability) {
        Intrinsics.checkNotNullParameter(capability, "capability");
        return this.tileEntity.hasCapability(capability, this.getOurDirection());
    }

    @logisticspipes.jetbrains.annotations.Nullable
    public final /* synthetic */ <C extends T> NeighborTileEntity<C> getInstanceOf() {
        int $i$f$getInstanceOf = 0;
        T t = this.getTileEntity();
        Intrinsics.reifiedOperationMarker(3, "C");
        return t instanceof TileEntity ? new NeighborTileEntity<T>(this.getTileEntity(), this.getDirection()) : null;
    }

    @NotNull
    public final <C extends T> Optional<NeighborTileEntity<C>> getJavaInstanceOf(@NotNull Class<C> clazz) {
        Optional<NeighborTileEntity<Object>> optional;
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        if (clazz.isInstance(this.tileEntity)) {
            C c = clazz.cast(this.tileEntity);
            Intrinsics.checkNotNullExpressionValue(c, "clazz.cast(tileEntity)");
            Optional<NeighborTileEntity<TileEntity>> optional2 = Optional.of(new NeighborTileEntity<TileEntity>((TileEntity)c, this.direction));
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, "Optional.of(NeighborTile\u2026(tileEntity), direction))");
        } else {
            Optional<NeighborTileEntity<C>> optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, "Optional.empty()");
        }
        return optional;
    }

    @Nullable
    @logisticspipes.jetbrains.annotations.Nullable
    public final IInventoryUtil getInventoryUtil() {
        return SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil((TileEntity)this.tileEntity, this.getOurDirection());
    }

    @Nonnull
    @NotNull
    public final IInventoryUtil getUtilForItemHandler() {
        Capability<IItemHandler> capability = LogisticsPipes.ITEM_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue(capability, "LogisticsPipes.ITEM_HANDLER_CAPABILITY");
        if (!this.hasCapability(capability)) {
            String string = "Constraint broken: getUtilForItemHandler was called, but adjacent tile entity is not an item handler";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        IInventoryUtil iInventoryUtil = this.getInventoryUtil();
        if (iInventoryUtil == null) {
            throw (Throwable)new NullPointerException("IInventoryUtil is null for an item handler");
        }
        return iInventoryUtil;
    }

    public final boolean isLogisticsPipe() {
        return this.tileEntity instanceof LogisticsTileGenericPipe;
    }

    public final boolean isItemHandler() {
        Capability<IItemHandler> capability = LogisticsPipes.ITEM_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue(capability, "LogisticsPipes.ITEM_HANDLER_CAPABILITY");
        return this.hasCapability(capability);
    }

    @NotNull
    public final NeighborTileEntitySneakyInsertion<T> sneakyInsertion() {
        return new NeighborTileEntitySneakyInsertion<T>(this.tileEntity, this.direction);
    }

    @NotNull
    public final T getTileEntity() {
        return this.tileEntity;
    }

    @NotNull
    public final EnumFacing getDirection() {
        return this.direction;
    }

    public NeighborTileEntity(@NotNull T tileEntity, @NotNull EnumFacing direction) {
        Intrinsics.checkNotNullParameter(tileEntity, "tileEntity");
        Intrinsics.checkNotNullParameter(direction, "direction");
        this.tileEntity = tileEntity;
        this.direction = direction;
    }
}

