/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;

public class ModStatusHelper {
    public static boolean isModLoaded(String modId) {
        if (modId.contains("@")) {
            ModContainer mod;
            String version = modId.substring(modId.indexOf(64) + 1);
            if (Loader.isModLoaded((String)(modId = modId.substring(0, modId.indexOf(64)))) && (mod = (ModContainer)Loader.instance().getIndexedModList().get(modId)) != null) {
                return mod.getVersion().startsWith(version);
            }
            return false;
        }
        if (Loader.isModLoaded((String)modId)) {
            return true;
        }
        return ModAPIManager.INSTANCE.hasAPI(modId);
    }

    public static boolean areModsLoaded(String modIds) {
        if (modIds.contains("+")) {
            for (String modId : modIds.split("\\+")) {
                if (ModStatusHelper.isModLoaded(modId)) continue;
                return false;
            }
            return true;
        }
        return ModStatusHelper.isModLoaded(modIds);
    }

    public static boolean isModVersionEqualsOrHigher(String modId, String version) {
        ComparableVersion v1 = new ComparableVersion(version);
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modId);
        if (mod != null) {
            ComparableVersion v2 = new ComparableVersion(mod.getVersion());
            return v1.compareTo(v2) <= 0;
        }
        return false;
    }
}

