/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.InventoryUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import network.rs485.logisticspipes.connection.NeighborTileEntity;

public class InventoryUtilFactory {
    private final ArrayList<SpecialInventoryHandler.Factory> handlerFactories = new ArrayList();

    public void registerHandler(@Nonnull SpecialInventoryHandler.Factory handlerFactory) {
        if (handlerFactory.init()) {
            this.handlerFactories.add(handlerFactory);
            LogisticsPipes.log.info("Loaded SpecialInventoryHandler.Factory: " + handlerFactory.getClass().getCanonicalName());
        } else {
            LogisticsPipes.log.warn("Could not load SpecialInventoryHandler.Factory: " + handlerFactory.getClass().getCanonicalName());
        }
    }

    @Nullable
    public SpecialInventoryHandler getUtilForInv(@Nonnull TileEntity inv, @Nullable EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return this.handlerFactories.stream().filter(factory -> factory.isType(inv, dir)).map(factory -> factory.getUtilForTile(inv, dir, hideOnePerStack, hideOne, cropStart, cropEnd)).filter(Objects::nonNull).findAny().orElse(null);
    }

    @Nullable
    public IInventoryUtil getInventoryUtil(@Nonnull NeighborTileEntity<TileEntity> adj) {
        return this.getHidingInventoryUtil(adj.getTileEntity(), adj.getOurDirection(), false, false, 0, 0);
    }

    @Nullable
    public IInventoryUtil getInventoryUtil(TileEntity inv, EnumFacing dir) {
        return this.getHidingInventoryUtil(inv, dir, false, false, 0, 0);
    }

    @Nullable
    public IInventoryUtil getHidingInventoryUtil(TileEntity tile, EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        if (tile != null) {
            SpecialInventoryHandler util = this.getUtilForInv(tile, dir, hideOnePerStack, hideOne, cropStart, cropEnd);
            if (util != null) {
                return util;
            }
            if (tile.hasCapability(LogisticsPipes.ITEM_HANDLER_CAPABILITY, dir)) {
                return new InventoryUtil((IItemHandler)tile.getCapability(LogisticsPipes.ITEM_HANDLER_CAPABILITY, dir), hideOnePerStack, hideOne, cropStart, cropEnd);
            }
        }
        return null;
    }
}

