/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.BufferTransfer;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataIOWrapper;

public class ClientPacketBufferHandlerThread {
    private final ClientCompressorThread clientCompressorThread = new ClientCompressorThread();
    private final ClientDecompressorThread clientDecompressorThread = new ClientDecompressorThread();

    private static byte[] compress(byte[] content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] decompress(byte[] contentBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int buffer;
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(contentBytes));
            while ((buffer = gzip.read()) != -1) {
                out.write(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public void clientTick() {
        this.clientDecompressorThread.clientTickEnd();
    }

    public void setPause(boolean flag) {
        this.clientCompressorThread.setPause(flag);
    }

    public void addPacketToCompressor(ModernPacket packet) {
        this.clientCompressorThread.addPacketToCompressor(packet);
    }

    public void handlePacket(byte[] content) {
        this.clientDecompressorThread.handlePacket(content);
    }

    public void clear() {
        this.clientCompressorThread.clear();
        this.clientDecompressorThread.clear();
    }

    public void queuePacket(ModernPacket packet, EntityPlayer player) {
        this.clientDecompressorThread.queuePacket(packet, player);
    }

    private static class ClientDecompressorThread
    extends Thread {
        private final LinkedList<byte[]> queue = new LinkedList();
        private final LinkedList<Pair<EntityPlayer, byte[]>> PacketBuffer = new LinkedList();
        private final ReentrantLock packetBufferLock = new ReentrantLock();
        private final LinkedList<Pair<EntityPlayer, ModernPacket>> retryPackets = new LinkedList();
        private final ReentrantLock retryPacketsLock = new ReentrantLock();
        private byte[] ByteBuffer = new byte[0];
        private boolean clear = false;

        public ClientDecompressorThread() {
            super("LogisticsPipes Packet Decompressor Client");
            this.setDaemon(true);
            this.start();
        }

        private void handlePacketData(Pair<EntityPlayer, byte[]> playerDataPair) {
            LPDataIOWrapper.provideData(playerDataPair.getValue2(), input -> PacketHandler.onPacketData(input, (EntityPlayer)playerDataPair.getValue1()));
        }

        public void clientTickEnd() {
            while (true) {
                Pair<EntityPlayer, byte[]> part = null;
                this.packetBufferLock.lock();
                try {
                    if (this.PacketBuffer.size() > 0) {
                        part = this.PacketBuffer.pop();
                    }
                }
                finally {
                    this.packetBufferLock.unlock();
                }
                if (part == null) break;
                this.handlePacketData(part);
            }
            while (true) {
                Pair<EntityPlayer, ModernPacket> partB = null;
                this.retryPacketsLock.lock();
                try {
                    if (this.retryPackets.size() > 0) {
                        partB = this.retryPackets.pop();
                    }
                }
                finally {
                    this.retryPacketsLock.unlock();
                }
                if (partB == null) break;
                PacketHandler.onPacketData(partB.getValue2(), partB.getValue1());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int size;
                boolean flag = false;
                byte[] buffer = null;
                LinkedList<byte[]> linkedList = this.queue;
                synchronized (linkedList) {
                    if (this.queue.size() > 0) {
                        flag = true;
                        buffer = this.queue.getFirst();
                        this.queue.removeFirst();
                    }
                }
                if (flag && buffer != null) {
                    byte[] packetbytes = ClientPacketBufferHandlerThread.decompress(buffer);
                    byte[] newBuffer = new byte[packetbytes.length + this.ByteBuffer.length];
                    System.arraycopy(this.ByteBuffer, 0, newBuffer, 0, this.ByteBuffer.length);
                    System.arraycopy(packetbytes, 0, newBuffer, this.ByteBuffer.length, packetbytes.length);
                    this.ByteBuffer = newBuffer;
                }
                if (flag) continue;
                while (this.ByteBuffer.length >= 4 && (size = ((this.ByteBuffer[0] & 0xFF) << 24) + ((this.ByteBuffer[1] & 0xFF) << 16) + ((this.ByteBuffer[2] & 0xFF) << 8) + ((this.ByteBuffer[3] & 0xFF) << 0)) + 4 <= this.ByteBuffer.length) {
                    byte[] packet = Arrays.copyOfRange(this.ByteBuffer, 4, size + 4);
                    this.ByteBuffer = Arrays.copyOfRange(this.ByteBuffer, size + 4, this.ByteBuffer.length);
                    this.packetBufferLock.lock();
                    try {
                        this.PacketBuffer.add(new Pair<EntityPlayer, byte[]>(MainProxy.proxy.getClientPlayer(), packet));
                    }
                    finally {
                        this.packetBufferLock.unlock();
                    }
                }
                LinkedList<byte[]> linkedList2 = this.queue;
                synchronized (linkedList2) {
                    while (this.queue.size() == 0) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!this.clear) continue;
                this.clear = false;
                this.ByteBuffer = new byte[0];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePacket(byte[] content) {
            LinkedList<byte[]> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(content);
                this.queue.notify();
            }
        }

        public void clear() {
            this.clear = true;
            this.queue.clear();
            this.retryPackets.clear();
        }

        public void queuePacket(ModernPacket packet, EntityPlayer player) {
            this.retryPackets.add(new Pair<EntityPlayer, ModernPacket>(player, packet));
        }
    }

    private static class ClientCompressorThread
    extends Thread {
        private final LinkedList<ModernPacket> clientList = new LinkedList();
        private byte[] clientBuffer = new byte[0];
        private boolean pause = false;
        private boolean clear = false;
        private Lock clearLock = new ReentrantLock();

        public ClientCompressorThread() {
            super("LogisticsPipes Packet Compressor Client");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                LinkedList<ModernPacket> linkedList = this.clientList;
                synchronized (linkedList) {
                    if (!this.pause && this.clientList.size() > 0) {
                        this.clientBuffer = LPDataIOWrapper.collectData(output -> {
                            output.writeBytes(this.clientBuffer);
                            this.clearLock.lock();
                            try {
                                for (ModernPacket packet : this.clientList) {
                                    output.writeByteArray(LPDataIOWrapper.collectData(dataOutput -> {
                                        dataOutput.writeShort(packet.getId());
                                        dataOutput.writeInt(packet.getDebugId());
                                        packet.writeData(dataOutput);
                                    }));
                                }
                            }
                            finally {
                                this.clientList.clear();
                                this.clearLock.unlock();
                            }
                        });
                    }
                }
                if (this.clientBuffer.length > 0) {
                    byte[] compressed;
                    byte[] sendbuffer;
                    while (this.clientBuffer.length > 32768) {
                        sendbuffer = Arrays.copyOf(this.clientBuffer, 32768);
                        this.clientBuffer = Arrays.copyOfRange(this.clientBuffer, 32768, this.clientBuffer.length);
                        compressed = ClientPacketBufferHandlerThread.compress(sendbuffer);
                        MainProxy.sendPacketToServer(PacketHandler.getPacket(BufferTransfer.class).setContent(compressed));
                    }
                    sendbuffer = this.clientBuffer;
                    this.clientBuffer = new byte[0];
                    compressed = ClientPacketBufferHandlerThread.compress(sendbuffer);
                    MainProxy.sendPacketToServer(PacketHandler.getPacket(BufferTransfer.class).setContent(compressed));
                }
                linkedList = this.clientList;
                synchronized (linkedList) {
                    while (this.pause || this.clientList.size() == 0) {
                        try {
                            this.clientList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!this.clear) continue;
                this.clear = false;
                this.clientBuffer = new byte[0];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPacketToCompressor(ModernPacket packet) {
            LinkedList<ModernPacket> linkedList = this.clientList;
            synchronized (linkedList) {
                this.clientList.add(packet);
                if (!this.pause) {
                    this.clientList.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPause(boolean flag) {
            LinkedList<ModernPacket> linkedList = this.clientList;
            synchronized (linkedList) {
                this.pause = flag;
                if (!this.pause) {
                    this.clientList.notify();
                }
            }
        }

        public void clear() {
            this.clear = true;
            new Thread(){

                @Override
                public void run() {
                    clearLock.lock();
                    clientList.clear();
                    clearLock.unlock();
                }
            }.start();
        }
    }
}

