/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.debug;

import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import logisticspipes.interfaces.IDebugHUDProvider;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.network.packets.routingdebug.RoutingUpdateCanidatePipe;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDebugCanidateList;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDebugClosedSet;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDebugFilters;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDoneDebug;
import logisticspipes.network.packets.routingdebug.RoutingUpdateInitDebug;
import logisticspipes.network.packets.routingdebug.RoutingUpdateSourcePipe;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipefxhandlers.PipeFXRenderHandler;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.debug.DebugWindow;
import logisticspipes.routing.debug.HUDRoutingTableDebugProvider;
import logisticspipes.routing.debug.HUDRoutingTableGeneralInfo;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class ClientViewController
implements IDebugHUDProvider {
    private static ClientViewController instance;
    private DoubleCoordinates mainPipe = null;
    private int tick = 0;
    private final List<DoubleCoordinates> canidates = new ArrayList<DoubleCoordinates>();
    private DebugWindow debugWindow;
    private List<IHeadUpDisplayRendererProvider> listHUD = new ArrayList<IHeadUpDisplayRendererProvider>();
    private HashMap<DoubleCoordinates, DebugInformation> HUDPositions = new HashMap();

    private ClientViewController() {
    }

    public static ClientViewController instance() {
        if (instance == null) {
            instance = new ClientViewController();
        }
        return instance;
    }

    private DebugInformation getDebugInformation(DoubleCoordinates pos) {
        DebugInformation info = this.HUDPositions.get(pos);
        if (info == null) {
            info = new DebugInformation();
            this.HUDPositions.put(pos, info);
        }
        return info;
    }

    public void tick() {
        if (this.tick++ % 5 != 0) {
            return;
        }
        if (this.mainPipe != null) {
            PipeFXRenderHandler.spawnGenericParticle(Particles.WhiteParticle, this.mainPipe.getXInt(), this.mainPipe.getYInt(), this.mainPipe.getZInt(), 1);
        }
        for (DoubleCoordinates pos : this.canidates) {
            PipeFXRenderHandler.spawnGenericParticle(Particles.OrangeParticle, pos.getXInt(), pos.getYInt(), pos.getZInt(), 1);
        }
    }

    public void clear() {
        this.mainPipe = null;
        this.canidates.clear();
        this.listHUD.clear();
        this.HUDPositions.clear();
    }

    public void handlePacket(RoutingUpdateSourcePipe routingUpdateSourcePipe) {
        this.mainPipe = routingUpdateSourcePipe.getExitRoute().destination.getLPPosition();
        this.getDebugInformation((DoubleCoordinates)this.mainPipe).nextFlags = routingUpdateSourcePipe.getExitRoute().getFlags();
    }

    public void handlePacket(RoutingUpdateCanidatePipe routingUpdateCanidatePipe) {
        DoubleCoordinates pos = routingUpdateCanidatePipe.getExitRoute().destination.getLPPosition();
        this.canidates.add(routingUpdateCanidatePipe.getExitRoute().destination.getLPPosition());
        this.getDebugInformation((DoubleCoordinates)pos).isNew = true;
        this.getDebugInformation((DoubleCoordinates)pos).newIndex = routingUpdateCanidatePipe.getExitRoute().debug.index;
    }

    public void init(RoutingUpdateInitDebug routingUpdateInitDebug) {
        this.debugWindow = new DebugWindow("Debug Code", 500, 250);
        LogisticsHUDRenderer.instance().debugHUD = this;
    }

    public void done(RoutingUpdateDoneDebug routingUpdateDoneDebug) {
        if (this.debugWindow != null) {
            this.debugWindow.setVisible(false);
            this.debugWindow = null;
        }
        LogisticsHUDRenderer.instance().debugHUD = null;
        this.listHUD.clear();
        this.HUDPositions.clear();
    }

    public void handlePacket(RoutingUpdateDebugClosedSet routingUpdateDebugClosedSet) {
        this.getDebugInformation((DoubleCoordinates)routingUpdateDebugClosedSet.getPos()).closedSet = routingUpdateDebugClosedSet.getSet();
    }

    public void handlePacket(RoutingUpdateDebugFilters routingUpdateDebugFilters) {
        this.getDebugInformation((DoubleCoordinates)routingUpdateDebugFilters.getPos()).filters = routingUpdateDebugFilters.getFilterPositions();
    }

    public void updateList(RoutingUpdateDebugCanidateList routingUpdateDebugCanidateList) {
        this.debugWindow.clear();
        int i = 0;
        for (ExitRoute exit : routingUpdateDebugCanidateList.getExitRoutes()) {
            ++i;
            Color color = Color.BLACK;
            if (exit.debug.isNewlyAddedCanidate) {
                color = Color.BLUE;
            }
            this.debugWindow.showInfo(exit.destination.toString(), color);
            this.debugWindow.showInfo("\n", color);
            for (int j = 0; j < 2; ++j) {
                this.debugWindow.showInfo("\t", color);
            }
            this.debugWindow.showInfo(exit.debug.toStringNetwork, color);
            this.debugWindow.showInfo("\n", color);
            DoubleCoordinates pos = exit.destination.getLPPosition();
            this.getDebugInformation((DoubleCoordinates)pos).routes.add(exit);
            this.getDebugInformation((DoubleCoordinates)pos).positions.add(i);
        }
        this.listHUD.addAll(this.HUDPositions.entrySet().stream().map(entry -> new HUDRoutingTableDebugProvider(new HUDRoutingTableGeneralInfo((DebugInformation)entry.getValue()), (DoubleCoordinates)entry.getKey())).collect(Collectors.toList()));
    }

    @Override
    public List<IHeadUpDisplayRendererProvider> getHUDs() {
        return this.listHUD;
    }

    public static class DebugInformation {
        public boolean isNew = false;
        public int newIndex = -1;
        public List<Integer> positions = new ArrayList<Integer>();
        public List<ExitRoute> routes = new ArrayList<ExitRoute>();
        public EnumSet<PipeRoutingConnectionType> closedSet;
        public EnumMap<PipeRoutingConnectionType, List<List<DoubleCoordinates>>> filters;
        public EnumSet<PipeRoutingConnectionType> nextFlags;
    }
}

