/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.state;

import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public class ConnectionMatrix {
    private int mask = 0;
    private int isBCPipeMask = 0;
    private int isTDPipeMask = 0;
    private boolean dirty = false;

    public boolean isConnected(EnumFacing direction) {
        return (this.mask & 1 << direction.ordinal()) != 0;
    }

    public void setConnected(EnumFacing direction, boolean value) {
        if (this.isConnected(direction) != value) {
            this.mask ^= 1 << direction.ordinal();
            this.dirty = true;
        }
        if (!value) {
            this.setBCConnected(direction, false);
            this.setTDConnected(direction, false);
        }
    }

    public boolean isBCConnected(EnumFacing direction) {
        return direction != null && (this.isBCPipeMask & 1 << direction.ordinal()) != 0;
    }

    public void setBCConnected(EnumFacing direction, boolean value) {
        if (this.isBCConnected(direction) != value) {
            this.isBCPipeMask ^= 1 << direction.ordinal();
            this.dirty = true;
        }
    }

    public boolean isTDConnected(EnumFacing direction) {
        return direction != null && (this.isTDPipeMask & 1 << direction.ordinal()) != 0;
    }

    public void setTDConnected(EnumFacing direction, boolean value) {
        if (this.isTDConnected(direction) != value) {
            this.isTDPipeMask ^= 1 << direction.ordinal();
            this.dirty = true;
        }
    }

    public int getMask() {
        return this.mask;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(LPDataOutput output) {
        output.writeByte(this.mask);
        output.writeByte(this.isBCPipeMask);
        output.writeByte(this.isTDPipeMask);
    }

    public void readData(LPDataInput input) {
        byte newMask = input.readByte();
        if (newMask != this.mask) {
            this.mask = newMask;
            this.dirty = true;
        }
        if ((newMask = input.readByte()) != this.isBCPipeMask) {
            this.isBCPipeMask = newMask;
            this.dirty = true;
        }
        if ((newMask = input.readByte()) != this.isTDPipeMask) {
            this.isTDPipeMask = newMask;
            this.dirty = true;
        }
    }
}

