/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.td;

import cofh.thermaldynamics.duct.tiles.TileDuctItem;
import cofh.thermaldynamics.render.RenderDuct;
import java.util.List;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ITDProxy;
import logisticspipes.proxy.object3d.interfaces.TextureTransformation;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.td.TDDuctInformationProvider;
import logisticspipes.proxy.td.subproxies.ITDPart;
import logisticspipes.proxy.td.subproxies.TDPart;
import logisticspipes.renderer.newpipe.RenderEntry;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ThermalDynamicsProxy
implements ITDProxy {
    private TextureTransformation connectionTextureBasic;
    private TextureTransformation connectionTextureActive;
    private TextureTransformation connectionTextureInactive;

    @Override
    public void registerPipeInformationProvider() {
        SimpleServiceLocator.pipeInformationManager.registerProvider(TileDuctItem.class, TDDuctInformationProvider.class);
    }

    @Override
    public ITDPart getTDPart(LogisticsTileGenericPipe pipe) {
        return new TDPart(pipe);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isItemDuct(TileEntity tile) {
        return tile instanceof TileDuctItem;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPipeConnections(LogisticsTileGenericPipe pipeTile, List<RenderEntry> renderList) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!pipeTile.renderState.pipeConnectionMatrix.isTDConnected(dir)) continue;
            TextureTransformation texture = this.connectionTextureBasic;
            if (pipeTile.renderState.textureMatrix.isRouted()) {
                texture = pipeTile.renderState.textureMatrix.isRoutedInDir(dir) ? this.connectionTextureActive : this.connectionTextureInactive;
            }
            double move = 0.25;
            LPTranslation localTranslation = new LPTranslation(0.5 + (double)dir.func_176730_m().func_177958_n() * move, 0.5 + (double)dir.func_176730_m().func_177956_o() * move, 0.5 + (double)dir.func_176730_m().func_177952_p() * move);
            renderList.add(new RenderEntry(SimpleServiceLocator.cclProxy.wrapModel(RenderDuct.modelConnection[2][dir.ordinal()]), localTranslation, texture));
        }
    }

    @Override
    public void registerTextures(TextureMap iconRegister) {
        if (this.connectionTextureBasic == null) {
            this.connectionTextureBasic = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/thermaldynamicsconnection-basic")));
            this.connectionTextureActive = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/thermaldynamicsconnection-active")));
            this.connectionTextureInactive = SimpleServiceLocator.cclProxy.createIconTransformer(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/thermaldynamicsconnection-inactive")));
        } else {
            this.connectionTextureBasic.update(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/thermaldynamicsconnection-basic")));
            this.connectionTextureActive.update(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/thermaldynamicsconnection-active")));
            this.connectionTextureInactive.update(iconRegister.func_174942_a(new ResourceLocation("logisticspipes", "blocks/pipes/thermaldynamicsconnection-inactive")));
        }
    }

    @Override
    public boolean isBlockedSide(TileEntity with, EnumFacing opposite) {
        if (!(with instanceof TileDuctItem)) {
            return false;
        }
        return ((TileDuctItem)with).isSideBlocked(opposite.ordinal());
    }
}

