/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class BarrelInventoryHandler
extends SpecialInventoryHandler
implements SpecialInventoryHandler.Factory {
    private static Class<?> barrelClass;
    private static Method getItemCount;
    private static Method setItemCount;
    private static Method getMaxSize;
    private static Field item;
    private final TileEntity _tile;
    private final boolean _hideOnePerStack;

    private BarrelInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public BarrelInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        try {
            barrelClass = Class.forName("factorization.weird.TileEntityDayBarrel");
            getItemCount = barrelClass.getDeclaredMethod("getItemCount", new Class[0]);
            setItemCount = barrelClass.getDeclaredMethod("setItemCount", Integer.TYPE);
            getMaxSize = barrelClass.getDeclaredMethod("getMaxSize", new Class[0]);
            item = barrelClass.getDeclaredField("item");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isType(@Nonnull TileEntity tile, @Nullable EnumFacing dir) {
        return SimpleServiceLocator.factorizationProxy.isBarral(tile);
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(@Nonnull TileEntity tile, @Nullable EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new BarrelInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(@Nonnull ItemIdentifier itemIdent) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null && !itemStack.func_190926_b() && ItemIdentifier.get(itemStack).equals(itemIdent)) {
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                return value - (this._hideOnePerStack ? 1 : 0);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    @Nonnull
    public ItemStack getMultipleItems(@Nonnull ItemIdentifier itemIdent, int count2) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null && !itemStack.func_190926_b()) {
                if (!ItemIdentifier.get(itemStack).equals(itemIdent)) {
                    return ItemStack.field_190927_a;
                }
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                if (value - (this._hideOnePerStack ? 1 : 0) < count2) {
                    return ItemStack.field_190927_a;
                }
                setItemCount.invoke((Object)this._tile, value - count2);
                ItemStack ret = itemStack.func_77946_l();
                ret.func_190920_e(count2);
                return ret;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result2 = new TreeSet<ItemIdentifier>();
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null && !itemStack.func_190926_b()) {
                result2.add(ItemIdentifier.get(itemStack));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return result2;
    }

    @Override
    @Nonnull
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> map2 = new HashMap<ItemIdentifier, Integer>();
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null && !itemStack.func_190926_b()) {
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                map2.put(ItemIdentifier.get(itemStack), value - (this._hideOnePerStack ? 1 : 0));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return map2;
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null && !itemStack.func_190926_b()) {
                if (!ItemIdentifier.get(itemStack).equals(itemIdent)) {
                    return ItemStack.field_190927_a;
                }
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                if (value > (this._hideOnePerStack ? 1 : 0)) {
                    setItemCount.invoke((Object)this._tile, value - 1);
                    ItemStack ret = itemStack.func_77946_l();
                    ret.func_190920_e(1);
                    return ret;
                }
            }
            return ItemStack.field_190927_a;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    @Override
    public boolean containsUndamagedItem(@Nonnull ItemIdentifier itemIdent) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null && !itemStack.func_190926_b()) {
                return ItemIdentifier.get(itemStack).getUndamaged().equals(itemIdent);
            }
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int roomForItem(@Nonnull ItemStack stack) {
        return this.roomForItemInner(barrelStack -> barrelStack.func_77969_a(stack) && Objects.equals(barrelStack.func_77978_p(), stack.func_77978_p()) && barrelStack.areCapsCompatible(stack));
    }

    private int roomForItemInner(Function<ItemStack, Boolean> isStackEqual) {
        try {
            ItemStack barrelStack = (ItemStack)item.get(this._tile);
            int max = (Integer)getMaxSize.invoke((Object)this._tile, new Object[0]);
            if (barrelStack != null && !barrelStack.func_190926_b()) {
                if (!isStackEqual.apply(barrelStack).booleanValue()) {
                    return 0;
                }
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                return max - value;
            }
            return max;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    @Nonnull
    public ItemStack add(@Nonnull ItemStack stack, EnumFacing from, boolean doAdd) {
        assert (this._tile != null);
        ItemStack st = stack.func_77946_l();
        st.func_190920_e(0);
        if (from != EnumFacing.UP) {
            return st;
        }
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack == null) {
                st.func_190920_e(stack.func_190916_E());
                if (doAdd) {
                    ItemStack tst = stack.func_77946_l();
                    ((IInventory)this._tile).func_70299_a(0, tst);
                }
            } else {
                if (!ItemIdentifier.get(itemStack).equals(ItemIdentifier.get(stack))) {
                    return st;
                }
                int max = (Integer)getMaxSize.invoke((Object)this._tile, new Object[0]);
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                int room = max - value;
                st.func_190920_e(Math.max(Math.min(room, stack.func_190916_E()), 0));
                if (doAdd && st.func_190916_E() > 0) {
                    setItemCount.invoke((Object)this._tile, value + st.func_190916_E());
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return st;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int i) {
        if (i != 0) {
            return ItemStack.field_190927_a;
        }
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null && !itemStack.func_190926_b()) {
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                if ((value -= this._hideOnePerStack ? 1 : 0) > 0) {
                    ItemStack ret = itemStack.func_77946_l();
                    ret.func_190920_e(value);
                    return ret;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int i, int j) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
            j = Math.min(j, value - (this._hideOnePerStack ? 1 : 0));
            if (j > 0) {
                setItemCount.invoke((Object)this._tile, value - j);
                ItemStack ret = itemStack.func_77946_l();
                ret.func_190920_e(j);
                return ret;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return ItemStack.field_190927_a;
    }
}

