/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.proxy.specialinventoryhandler.LPActionSource;
import logisticspipes.proxy.specialinventoryhandler.LPStorageMonitorableAccessor;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class AEInterfaceInventoryHandler
extends SpecialInventoryHandler
implements SpecialInventoryHandler.Factory {
    public boolean init = false;
    private final boolean hideOnePerStack;
    private final TileEntity tile;
    private final EnumFacing dir;
    private final LPActionSource source;
    private IStorageMonitorableAccessor acc = null;
    IGridHost host;
    public IGridNode node;
    private LinkedList<Map.Entry<ItemIdentifier, Integer>> cached;

    private AEInterfaceInventoryHandler(TileEntity tile, EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this.tile = tile;
        this.hideOnePerStack = hideOnePerStack || hideOne;
        this.acc = (IStorageMonitorableAccessor)tile.getCapability(LPStorageMonitorableAccessor.STORAGE_MONITORABLE_ACCESSOR_CAPABILITY, dir);
        this.node = ((IGridHost)tile).getGridNode(AEPartLocation.fromFacing((EnumFacing)dir));
        this.host = this.node.getMachine();
        this.source = new LPActionSource(this);
        this.dir = dir;
    }

    public AEInterfaceInventoryHandler() {
        this.tile = null;
        this.hideOnePerStack = false;
        this.source = null;
        this.dir = null;
    }

    @Override
    public boolean isType(@Nonnull TileEntity tile, @Nullable EnumFacing dir) {
        if (tile instanceof IGridHost && tile.hasCapability(LPStorageMonitorableAccessor.STORAGE_MONITORABLE_ACCESSOR_CAPABILITY, dir)) {
            return ((IGridHost)tile).getGridNode(AEPartLocation.fromFacing((EnumFacing)dir)) != null;
        }
        return false;
    }

    @Override
    public boolean init() {
        this.init = true;
        return true;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(@Nonnull TileEntity tile, @Nullable EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new AEInterfaceInventoryHandler(tile, dir, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    @Nonnull
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return this.getItemsAndCount(false);
    }

    private Map<ItemIdentifier, Integer> getItemsAndCount(boolean linked) {
        HashMap result2 = linked ? new LinkedHashMap() : new HashMap();
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null || tmp.getInventory((IStorageChannel)channel).getStorageList() == null) {
            return result2;
        }
        IItemList items = tmp.getInventory((IStorageChannel)channel).getStorageList();
        for (IAEItemStack item : items) {
            ItemIdentifier ident = ItemIdentifier.get(item.createItemStack());
            Integer count2 = (Integer)result2.get(ident);
            if (count2 != null) {
                result2.put((ItemIdentifier)ident, (int)((long)count2.intValue() + item.getStackSize() - (long)(this.hideOnePerStack ? 1 : 0)));
                continue;
            }
            result2.put((ItemIdentifier)ident, (int)(item.getStackSize() - (long)(this.hideOnePerStack ? 1 : 0)));
        }
        return result2;
    }

    @Override
    @Nonnull
    public ItemStack getSingleItem(ItemIdentifier item) {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null) {
            return ItemStack.field_190927_a;
        }
        IAEItemStack stack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)item.makeNormalStack(1));
        IAEItemStack extract = (IAEItemStack)tmp.getInventory((IStorageChannel)channel).extractItems((IAEStack)stack, Actionable.MODULATE, (IActionSource)this.source);
        if (extract == null) {
            return ItemStack.field_190927_a;
        }
        return extract.createItemStack();
    }

    @Override
    @Nonnull
    public ItemStack getMultipleItems(@Nonnull ItemIdentifier itemIdent, int count2) {
        if (this.itemCount(itemIdent) < count2) {
            return ItemStack.field_190927_a;
        }
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null) {
            return ItemStack.field_190927_a;
        }
        IAEItemStack stack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)itemIdent.makeNormalStack(count2));
        IAEItemStack extract = (IAEItemStack)tmp.getInventory((IStorageChannel)channel).extractItems((IAEStack)stack, Actionable.MODULATE, (IActionSource)this.source);
        if (extract == null) {
            return ItemStack.field_190927_a;
        }
        return extract.createItemStack();
    }

    @Override
    public boolean containsUndamagedItem(@Nonnull ItemIdentifier itemIdent) {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null || tmp.getInventory((IStorageChannel)channel).getStorageList() == null) {
            return false;
        }
        IItemList items = tmp.getInventory((IStorageChannel)channel).getStorageList();
        for (IAEItemStack item : items) {
            ItemIdentifier ident = ItemIdentifier.get(item.createItemStack());
            if (!ident.equals(itemIdent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(@Nonnull ItemStack itemStack) {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null) {
            return 0;
        }
        IAEItemStack stack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)itemStack);
        if (stack == null) {
            return 0;
        }
        while (stack.getStackSize() > 0L) {
            if (tmp.getInventory((IStorageChannel)channel).canAccept((IAEStack)stack)) {
                return stack.getStackSize() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)stack.getStackSize();
            }
            stack.decStackSize(1L);
        }
        return 0;
    }

    @Override
    @Nonnull
    public Set<ItemIdentifier> getItems() {
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        TreeSet<ItemIdentifier> result2 = new TreeSet<ItemIdentifier>();
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null || tmp.getInventory((IStorageChannel)channel).getStorageList() == null) {
            return result2;
        }
        IItemList items = tmp.getInventory((IStorageChannel)channel).getStorageList();
        for (IAEItemStack item : items) {
            ItemIdentifier ident = ItemIdentifier.get(item.createItemStack());
            result2.add(ident);
        }
        return result2;
    }

    @Override
    public int getSizeInventory() {
        if (this.cached == null) {
            this.initCache();
        }
        return this.cached.size() + 1;
    }

    private void initCache() {
        Map<ItemIdentifier, Integer> map2 = this.getItemsAndCount(true);
        this.cached = new LinkedList();
        this.cached.addAll(map2.entrySet());
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.cached == null) {
            this.initCache();
        }
        if (slot >= this.cached.size()) {
            return ItemStack.field_190927_a;
        }
        Map.Entry<ItemIdentifier, Integer> entry = this.cached.get(slot);
        if (entry.getValue() == 0) {
            return ItemStack.field_190927_a;
        }
        return entry.getKey().makeNormalStack(entry.getValue());
    }

    @Override
    @Nonnull
    public ItemStack decrStackSize(int slot, int amount) {
        if (this.cached == null) {
            this.initCache();
        }
        if (slot >= this.cached.size()) {
            return ItemStack.field_190927_a;
        }
        Map.Entry<ItemIdentifier, Integer> entry = this.cached.get(slot);
        return this.getMultipleItems(entry.getKey(), amount);
    }

    @Override
    @Nonnull
    public ItemStack add(@Nonnull ItemStack stack, EnumFacing from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        IItemStorageChannel channel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IAEItemStack tst = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack);
        IStorageMonitorable tmp = this.acc.getInventory((IActionSource)this.source);
        if (tmp == null || tmp.getInventory((IStorageChannel)channel) == null) {
            return st;
        }
        IAEItemStack overflow = (IAEItemStack)tmp.getInventory((IStorageChannel)channel).injectItems((IAEStack)tst, Actionable.MODULATE, (IActionSource)this.source);
        if (overflow != null) {
            st.func_190920_e((int)((long)st.func_190916_E() - overflow.getStackSize()));
        }
        return st;
    }
}

