/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.upgrades;

import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.items.ItemUpgrade;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.upgrades.ActionSpeedUpgrade;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.CraftingByproductUpgrade;
import logisticspipes.pipes.upgrades.CraftingCleanupUpgrade;
import logisticspipes.pipes.upgrades.FluidCraftingUpgrade;
import logisticspipes.pipes.upgrades.FuzzyUpgrade;
import logisticspipes.pipes.upgrades.IConfigPipeUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.ItemExtractionUpgrade;
import logisticspipes.pipes.upgrades.ItemStackExtractionUpgrade;
import logisticspipes.pipes.upgrades.PatternUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgradeConfig;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.item.SimpleStackInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class ModuleUpgradeManager
implements ISimpleInventoryEventHandler,
ISlotUpgradeManager {
    private final UpgradeManager parent;
    private SimpleStackInventory inv = new SimpleStackInventory(2, "UpgradeInventory", 16);
    private IPipeUpgrade[] upgrades = new IPipeUpgrade[2];
    private PipeLogisticsChassi pipe;
    private EnumFacing sneakyOrientation = null;
    private boolean isAdvancedCrafter = false;
    private boolean isFuzzyUpgrade = false;
    private int liquidCrafter = 0;
    private boolean hasByproductExtractor = false;
    private boolean hasPatternUpgrade = false;
    private int craftingCleanup = 0;
    private int actionSpeedUpgrade = 0;
    private int itemExtractionUpgrade = 0;
    private int itemStackExtractionUpgrade = 0;
    private boolean[] guiUpgrades = new boolean[2];

    public ModuleUpgradeManager(PipeLogisticsChassi pipe, UpgradeManager parent) {
        this.pipe = pipe;
        this.parent = parent;
        this.inv.addListener(this);
    }

    @Override
    public boolean hasPatternUpgrade() {
        return this.hasPatternUpgrade || this.parent.hasPatternUpgrade();
    }

    @Override
    public boolean isAdvancedSatelliteCrafter() {
        return this.isAdvancedCrafter || this.parent.isAdvancedSatelliteCrafter();
    }

    @Override
    public boolean hasByproductExtractor() {
        return this.hasByproductExtractor || this.parent.hasByproductExtractor();
    }

    @Override
    public int getFluidCrafter() {
        return Math.min(this.liquidCrafter + this.parent.getFluidCrafter(), 3);
    }

    @Override
    public boolean isFuzzyUpgrade() {
        return this.isFuzzyUpgrade || this.parent.isFuzzyUpgrade();
    }

    @Override
    public int getCrafterCleanup() {
        return Math.min(this.craftingCleanup + this.parent.getCrafterCleanup(), 4);
    }

    @Override
    public boolean hasSneakyUpgrade() {
        if (this.sneakyOrientation != null) {
            return true;
        }
        return this.parent.hasSneakyUpgrade();
    }

    @Override
    public EnumFacing getSneakyOrientation() {
        if (this.sneakyOrientation != null) {
            return this.sneakyOrientation;
        }
        return this.parent.getSneakyOrientation();
    }

    @Override
    public boolean hasOwnSneakyUpgrade() {
        return this.sneakyOrientation != null;
    }

    @Override
    public IPipeUpgrade getUpgrade(int slot) {
        return this.upgrades[slot];
    }

    @Override
    public DoubleCoordinates getPipePosition() {
        return this.pipe.getLPPosition();
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        int i;
        boolean needUpdate = false;
        for (i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack item = this.inv.func_70301_a(i);
            if (item.func_190926_b()) {
                if (this.upgrades[i] == null) continue;
                needUpdate |= this.removeUpgrade(i, this.upgrades);
                continue;
            }
            needUpdate |= this.updateModule(i, this.upgrades, this.inv);
        }
        this.sneakyOrientation = null;
        this.isAdvancedCrafter = false;
        this.isFuzzyUpgrade = false;
        this.liquidCrafter = 0;
        this.hasByproductExtractor = false;
        this.hasPatternUpgrade = false;
        this.craftingCleanup = 0;
        this.actionSpeedUpgrade = 0;
        this.itemExtractionUpgrade = 0;
        this.itemStackExtractionUpgrade = 0;
        this.guiUpgrades = new boolean[2];
        for (i = 0; i < this.upgrades.length; ++i) {
            IPipeUpgrade upgrade = this.upgrades[i];
            if (upgrade instanceof SneakyUpgradeConfig && this.sneakyOrientation == null) {
                ItemStack stack = this.inv.func_70301_a(i);
                this.sneakyOrientation = ((SneakyUpgradeConfig)upgrade).getSide(stack);
            } else if (upgrade instanceof AdvancedSatelliteUpgrade) {
                this.isAdvancedCrafter = true;
            } else if (upgrade instanceof FuzzyUpgrade) {
                this.isFuzzyUpgrade = true;
            } else if (upgrade instanceof FluidCraftingUpgrade) {
                this.liquidCrafter += this.inv.func_70301_a(i).func_190916_E();
            } else if (upgrade instanceof CraftingByproductUpgrade) {
                this.hasByproductExtractor = true;
            } else if (upgrade instanceof PatternUpgrade) {
                this.hasPatternUpgrade = true;
            } else if (upgrade instanceof CraftingCleanupUpgrade) {
                this.craftingCleanup += this.inv.func_70301_a(i).func_190916_E();
            } else if (upgrade instanceof ActionSpeedUpgrade) {
                this.actionSpeedUpgrade += this.inv.func_70301_a(i).func_190916_E();
            } else if (upgrade instanceof ItemExtractionUpgrade) {
                this.itemExtractionUpgrade += this.inv.func_70301_a(i).func_190916_E();
            } else if (upgrade instanceof ItemStackExtractionUpgrade) {
                this.itemStackExtractionUpgrade += this.inv.func_70301_a(i).func_190916_E();
            }
            if (!(upgrade instanceof IConfigPipeUpgrade)) continue;
            this.guiUpgrades[i] = true;
        }
        this.liquidCrafter = Math.min(this.liquidCrafter, 3);
        this.craftingCleanup = Math.min(this.craftingCleanup, 4);
        this.itemExtractionUpgrade = Math.min(this.itemExtractionUpgrade, 8);
        this.itemStackExtractionUpgrade = Math.min(this.itemStackExtractionUpgrade, 8);
        if (needUpdate) {
            this.pipe.connectionUpdate();
            if (this.pipe.container != null) {
                this.pipe.container.sendUpdateToClient();
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound, String prefix) {
        this.inv.readFromNBT(nbttagcompound, "ModuleUpgradeInventory_" + prefix);
        this.InventoryChanged(this.inv);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound, String prefix) {
        this.inv.writeToNBT(nbttagcompound, "ModuleUpgradeInventory_" + prefix);
        this.InventoryChanged(this.inv);
    }

    private boolean updateModule(int slot, IPipeUpgrade[] upgrades, IInventory inv) {
        ItemStack stackInSlot = inv.func_70301_a(slot);
        upgrades[slot] = stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof ItemUpgrade) ? null : ((ItemUpgrade)stackInSlot.func_77973_b()).getUpgradeForItem(stackInSlot, upgrades[slot]);
        if (upgrades[slot] == null) {
            inv.func_70299_a(slot, ItemStack.field_190927_a);
            return false;
        }
        return upgrades[slot].needsUpdate();
    }

    private boolean removeUpgrade(int slot, IPipeUpgrade[] upgrades) {
        boolean needUpdate = upgrades[slot].needsUpdate();
        upgrades[slot] = null;
        return needUpdate;
    }

    public boolean hasGuiUpgrade(int i) {
        return this.guiUpgrades[i];
    }

    @Override
    public int getActionSpeedUpgrade() {
        return this.actionSpeedUpgrade;
    }

    @Override
    public int getItemExtractionUpgrade() {
        return this.itemExtractionUpgrade;
    }

    @Override
    public int getItemStackExtractionUpgrade() {
        return this.itemStackExtractionUpgrade;
    }

    public void dropUpgrades() {
        this.inv.dropContents(this.pipe.getWorld(), this.pipe.getPos());
    }

    @Override
    public SimpleStackInventory getInv() {
        return this.inv;
    }
}

