/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import logisticspipes.gui.hud.HUDCrafting;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.orderer.OrdererManagerContent;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.signs.CraftingPipeSign;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCQueued;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IPromise;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrderManager;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.textures.Textures;
import logisticspipes.utils.IHavePriority;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

@CCType(name="LogisticsPipes:Crafting")
public class PipeItemsCraftingLogistics
extends CoreRoutedPipe
implements ICraftItems,
IRequireReliableTransport,
IHeadUpDisplayRendererProvider,
IChangeListener,
IOrderManagerContentReceiver,
IHavePriority {
    protected ModuleCrafter craftingModule;
    public final LinkedList<ItemIdentifierStack> oldList = new LinkedList();
    public final LinkedList<ItemIdentifierStack> displayList = new LinkedList();
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final HUDCrafting HUD = new HUDCrafting(this);
    private boolean doContentUpdate = true;

    public PipeItemsCraftingLogistics(Item item) {
        super(item);
        this.craftingModule = new ModuleCrafter(this);
        this.craftingModule.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
        this.throttleTime = 40;
        this._orderItemManager = new LogisticsItemOrderManager(this, (ILPPositionProvider)this);
    }

    @Override
    public void onNeighborBlockChange() {
        this.craftingModule.clearCache();
        super.onNeighborBlockChange();
    }

    @Override
    public void onAllowedRemoval() {
        while (this._orderItemManager.hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            this._orderItemManager.sendFailed();
        }
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.doContentUpdate) {
            this.checkContentUpdate();
        }
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_CRAFTER_TEXTURE;
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this.isEnabled()) {
            return;
        }
        this.craftingModule.canProvide(tree, root, filters);
    }

    @Override
    public ICraftingTemplate addCrafting(IResource toCraft) {
        if (!this.isEnabled()) {
            return null;
        }
        return this.craftingModule.addCrafting(toCraft);
    }

    @Override
    public LogisticsOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        return this.craftingModule.fullFill(promise, destination, info);
    }

    @Override
    public void registerExtras(IPromise promise) {
        this.craftingModule.registerExtras(promise);
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> list, List<IFilter> filters) {
        this.craftingModule.getAllItems(list, filters);
    }

    @Override
    public boolean canCraft(IResource toCraft) {
        return this.craftingModule.canCraft(toCraft);
    }

    @Override
    public List<ItemIdentifierStack> getCraftedItems() {
        return this.craftingModule.getCraftedItems();
    }

    @Override
    public ModuleCrafter getLogisticsModule() {
        return this.craftingModule;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public int getTodo() {
        return this._orderItemManager.totalAmountCountInAllOrders();
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrdererManagerContent.class).setIdentList(this.oldList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
            this.craftingModule.startWatching(player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
        this.craftingModule.stopWatching(player);
    }

    @Override
    public void listenedChanged() {
        this.doContentUpdate = true;
    }

    private void checkContentUpdate() {
        this.doContentUpdate = false;
        LinkedList<ItemIdentifierStack> all2 = this._orderItemManager.getContentList(this.getWorld());
        if (!this.oldList.equals(all2)) {
            this.oldList.clear();
            this.oldList.addAll(all2);
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(OrdererManagerContent.class).setIdentList(all2).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void setOrderManagerContent(Collection<ItemIdentifierStack> list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public double getLoadFactor() {
        return ((double)this._orderItemManager.totalAmountCountInAllOrders() + 63.0) / 64.0;
    }

    @CCCommand(description="Imports the crafting recipe from the connected machine/crafter")
    @CCQueued
    public void reimport() {
        this.craftingModule.importFromCraftingTable(null);
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
        this.craftingModule.collectSpecificInterests(itemidCollection);
    }

    @Override
    public int getPriority() {
        return this.craftingModule.getPriority();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.craftingModule.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.craftingModule.writeToNBT(nbttagcompound);
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        this.craftingModule.tick();
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this.craftingModule.itemArrived(item, info);
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this.craftingModule.itemLost(item, info);
    }

    public IInventory getDummyInventory() {
        return this.craftingModule.getDummyInventory();
    }

    public IInventory getFluidInventory() {
        return this.craftingModule.getFluidInventory();
    }

    public IInventory getCleanupInventory() {
        return this.craftingModule.getCleanupInventory();
    }

    public boolean hasCraftingSign() {
        for (int i = 0; i < 6; ++i) {
            if (!(this.signItem[i] instanceof CraftingPipeSign)) continue;
            return true;
        }
        return false;
    }
}

