/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDSatellite;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.ITankUtil;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleSatellite;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.hud.ChestContent;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.satpipe.SyncSatelliteNamePacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class PipeFluidSatellite
extends FluidRoutedPipe
implements IRequestFluid,
IRequireReliableFluidTransport,
IHeadUpDisplayRendererProvider,
IChestContentReceiver {
    public static HashSet<PipeFluidSatellite> AllSatellites = new HashSet();
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    public final LinkedList<ItemIdentifierStack> itemList = new LinkedList();
    public final LinkedList<ItemIdentifierStack> oldList = new LinkedList();
    private final HUDSatellite HUD = new HUDSatellite(this);
    protected final Map<FluidIdentifier, Integer> _lostItems = new HashMap<FluidIdentifier, Integer>();
    public String satellitePipeName = "";

    public static void cleanup() {
        AllSatellites.clear();
    }

    public PipeFluidSatellite(Item item) {
        super(item);
        this.throttleTime = 40;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_SATELLITE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return new ModuleSatellite(this);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.isNthTick(20) && this.localModeWatchers.size() > 0) {
            this.updateInv(false);
        }
    }

    @Override
    public void sendFailed(FluidIdentifier liquid, Integer amount) {
        this.liquidLost(liquid, amount);
    }

    private void addToList(ItemIdentifierStack stack) {
        for (ItemIdentifierStack ident : this.itemList) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.setStackSize(ident.getStackSize() + stack.getStackSize());
            return;
        }
        this.itemList.addLast(stack);
    }

    private void updateInv(boolean force) {
        this.itemList.clear();
        for (ITankUtil util : this.getAdjacentTanks(false)) {
            util.forEachFluid(liquid -> {
                if (liquid != null && liquid.getFluid() != null) {
                    this.addToList(liquid.getFluid().getItemIdentifier().makeStack(liquid.getAmount()));
                }
            });
        }
        if (!this.itemList.equals(this.oldList) || force) {
            this.oldList.clear();
            this.oldList.addAll(this.itemList);
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ChestContent.class).setIdentList(this.itemList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void setReceivedChestContent(Collection<ItemIdentifierStack> list) {
        this.itemList.clear();
        this.itemList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            CoordinatesPacket packet = PacketHandler.getPacket(SyncSatelliteNamePacket.class).setString(this.satellitePipeName).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
            MainProxy.sendPacketToPlayer(packet, player);
            this.updateInv(true);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("satelliteid")) {
            int satelliteId = nbttagcompound.func_74762_e("satelliteid");
            this.satellitePipeName = Integer.toString(satelliteId);
        } else {
            this.satellitePipeName = nbttagcompound.func_74779_i("satellitePipeName");
        }
        this.ensureAllSatelliteStatus();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("satellitePipeName", this.satellitePipeName);
        super.writeToNBT(nbttagcompound);
    }

    protected void ensureAllSatelliteStatus() {
        if (MainProxy.isClient()) {
            return;
        }
        if (this.satellitePipeName.isEmpty()) {
            AllSatellites.remove(this);
        }
        if (!this.satellitePipeName.isEmpty()) {
            AllSatellites.add(this);
        }
    }

    private void updateWatchers() {
        CoordinatesPacket packet = PacketHandler.getPacket(SyncSatelliteNamePacket.class).setString(this.satellitePipeName).setTilePos(this.getContainer());
        MainProxy.sendToPlayerList((ModernPacket)packet, this.localModeWatchers);
        MainProxy.sendPacketToAllWatchingChunk(this.getContainer(), (ModernPacket)packet);
    }

    @Override
    public void onAllowedRemoval() {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        AllSatellites.remove(this);
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        CoordinatesPacket packet = PacketHandler.getPacket(SyncSatelliteNamePacket.class).setString(this.satellitePipeName).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ());
        MainProxy.sendPacketToPlayer(packet, entityplayer);
        entityplayer.openGui((Object)LogisticsPipes.instance, 13, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<FluidIdentifier, Integer>> iterator2 = this._lostItems.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<FluidIdentifier, Integer> stack = iterator2.next();
            int received = RequestTree.requestFluidPartial(stack.getKey(), stack.getValue(), this, null);
            if (received <= 0) continue;
            if (received == stack.getValue()) {
                iterator2.remove();
                continue;
            }
            stack.setValue(stack.getValue() - received);
        }
    }

    public void setSatelliteName(String name) {
        this.satellitePipeName = name;
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            this.updateWatchers();
        }
        this.ensureAllSatelliteStatus();
    }

    @Override
    public void liquidLost(FluidIdentifier item, int amount) {
        if (this._lostItems.containsKey(item)) {
            this._lostItems.put(item, this._lostItems.get(item) + amount);
        } else {
            this._lostItems.put(item, amount);
        }
    }

    @Override
    public void liquidArrived(FluidIdentifier item, int amount) {
    }

    @Override
    public void liquidNotInserted(FluidIdentifier item, int amount) {
        this.liquidLost(item, amount);
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }

    public String getSatellitePipeName() {
        return this.satellitePipeName;
    }
}

