/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.routingdebug;

import logisticspipes.commands.chathelper.LPChatListener;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.gui.OpenChatGui;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.debug.DebugController;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class RoutingUpdateTargetResponse
extends ModernPacket {
    private TargetMode mode;
    private int[] additions = new int[0];

    public RoutingUpdateTargetResponse(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.mode = TargetMode.values()[input.readByte()];
        this.additions = input.readIntArray();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (this.mode == TargetMode.None) {
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "No Target Found"));
        } else if (this.mode == TargetMode.Block) {
            int x = this.additions[0];
            int y = this.additions[1];
            int z = this.additions[2];
            player.func_145747_a((ITextComponent)new TextComponentString("Checking Block at: x:" + x + " y:" + y + " z:" + z));
            Block id = player.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            player.func_145747_a((ITextComponent)new TextComponentString("Found Block with Id: " + Block.func_149682_b((Block)id)));
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(x, y, z));
            if (tile == null) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "No TileEntity found"));
            } else if (!(tile instanceof LogisticsTileGenericPipe)) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "No LogisticsTileGenericPipe found"));
            } else if (!(((LogisticsTileGenericPipe)tile).pipe instanceof CoreRoutedPipe)) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "No CoreRoutedPipe found"));
            } else {
                LPChatListener.addTask(() -> {
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.GREEN) + "Starting RoutingTable debug update."));
                    DebugController.instance((ICommandSender)player).debug((ServerRouter)((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).getRouter());
                    MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
                    return true;
                }, (ICommandSender)player);
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.AQUA) + "Start RoutingTable debug update ? " + (Object)((Object)ChatColor.RESET) + "<" + (Object)((Object)ChatColor.GREEN) + "yes" + (Object)((Object)ChatColor.RESET) + "/" + (Object)((Object)ChatColor.RED) + "no" + (Object)((Object)ChatColor.RESET) + ">"));
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OpenChatGui.class), player);
            }
        } else if (this.mode == TargetMode.Entity) {
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "Entity not allowed"));
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeByte(this.mode.ordinal());
        output.writeIntArray(this.additions);
    }

    @Override
    public ModernPacket template() {
        return new RoutingUpdateTargetResponse(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public TargetMode getMode() {
        return this.mode;
    }

    public RoutingUpdateTargetResponse setMode(TargetMode mode) {
        this.mode = mode;
        return this;
    }

    public int[] getAdditions() {
        return this.additions;
    }

    public RoutingUpdateTargetResponse setAdditions(int[] additions) {
        this.additions = additions;
        return this;
    }

    public static enum TargetMode {
        Block,
        Entity,
        None;

    }
}

