/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.orderer;

import java.util.ArrayList;
import java.util.Collection;
import logisticspipes.asm.ClientSideOnlyMethodContent;
import logisticspipes.config.Configs;
import logisticspipes.gui.orderer.GuiOrderer;
import logisticspipes.gui.orderer.GuiRequestTable;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ResourceNetwork;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.FMLClientHandler;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class MissingItems
extends ModernPacket {
    private Collection<IResource> items = new ArrayList<IResource>();
    private boolean flag;

    public MissingItems(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new MissingItems(this.getId());
    }

    @Override
    @ClientSideOnlyMethodContent
    public void processPacket(EntityPlayer player) {
        if (Configs.DISPLAY_POPUP && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiOrderer) {
            ((GuiOrderer)FMLClientHandler.instance().getClient().field_71462_r).handleRequestAnswer(this.getItems(), this.isFlag(), (GuiOrderer)FMLClientHandler.instance().getClient().field_71462_r, player);
        } else if (Configs.DISPLAY_POPUP && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiRequestTable) {
            ((GuiRequestTable)FMLClientHandler.instance().getClient().field_71462_r).handleRequestAnswer(this.getItems(), this.isFlag(), (GuiRequestTable)FMLClientHandler.instance().getClient().field_71462_r, player);
        } else if (this.isFlag()) {
            for (IResource item : this.items) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.RED) + "Missing: " + item.getDisplayText(IResource.ColorCode.MISSING)));
            }
        } else {
            for (IResource item : this.items) {
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.GREEN) + "Requested: " + item.getDisplayText(IResource.ColorCode.SUCCESS)));
            }
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)ChatColor.GREEN) + "Request successful!"));
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeCollection(this.items);
        output.writeBoolean(this.isFlag());
    }

    @Override
    public void readData(LPDataInput input) {
        this.items = input.readArrayList(ResourceNetwork::readResource);
        this.setFlag(input.readBoolean());
    }

    public Collection<IResource> getItems() {
        return this.items;
    }

    public MissingItems setItems(Collection<IResource> items) {
        this.items = items;
        return this;
    }

    public MissingItems setFlag(boolean flag) {
        this.flag = flag;
        return this;
    }

    public boolean isFlag() {
        return this.flag;
    }
}

