/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import logisticspipes.LogisticsPipes;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.PlayerIdentifier;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.config.ClientConfiguration;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class PlayerConfigToServerPacket
extends ModernPacket {
    private ClientConfiguration config;

    public PlayerConfigToServerPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.config = new ClientConfiguration();
        this.config.read(input);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsPipes.getServerConfigManager().setClientConfiguration(PlayerIdentifier.get(player), this.config);
    }

    @Override
    public void writeData(LPDataOutput output) {
        this.config.write(output);
    }

    @Override
    public ModernPacket template() {
        return new PlayerConfigToServerPacket(this.getId());
    }

    public ClientConfiguration getConfig() {
        return this.config;
    }

    public PlayerConfigToServerPacket setConfig(ClientConfiguration config) {
        this.config = config;
        return this;
    }
}

