/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class NEISetCraftingRecipe
extends CoordinatesPacket {
    private NonNullList<ItemStack> stackList = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);

    public NEISetCraftingRecipe(int id) {
        super(id);
    }

    public NonNullList<ItemStack> getStackList() {
        return this.stackList;
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileEntity tile = this.getTileAs(player.field_70170_p, TileEntity.class);
        if (tile instanceof LogisticsCraftingTableTileEntity) {
            ((LogisticsCraftingTableTileEntity)tile).handleNEIRecipePacket(this.getStackList());
        } else if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            ((PipeBlockRequestTable)((LogisticsTileGenericPipe)tile).pipe).handleNEIRecipePacket(this.getStackList());
        }
    }

    @Override
    public ModernPacket template() {
        return new NEISetCraftingRecipe(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeCollection(this.stackList, (out, stack) -> out.writeNBTTagCompound(stack.func_190926_b() ? null : stack.func_77955_b(new NBTTagCompound())));
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        NonNullList<ItemStack> readList = input.readNonNullList(inp -> {
            NBTTagCompound tag = inp.readNBTTagCompound();
            return tag == null ? null : new ItemStack(tag);
        }, ItemStack.field_190927_a);
        if (readList != null) {
            this.stackList = readList;
        }
    }
}

