/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.util.Optional;
import java.util.UUID;
import logisticspipes.interfaces.routing.IChannelManager;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.AddNewChannelPacket;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class EditChannelPacket
extends AddNewChannelPacket {
    private UUID channelIdentifier;

    public EditChannelPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.channelIdentifier = input.readUUID();
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeUUID(this.channelIdentifier);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        IChannelManager manager = SimpleServiceLocator.channelManagerProvider.getChannelManager(player.func_130014_f_());
        Optional<ChannelInformation> channelOpt = manager.getChannels().stream().filter(chan -> chan.getChannelIdentifier().equals(this.channelIdentifier)).findFirst();
        if (channelOpt.isPresent()) {
            ChannelInformation channel = channelOpt.get();
            if (!channel.getName().equals(this.getName())) {
                manager.updateChannelName(this.channelIdentifier, this.getName());
            }
            if (!channel.getRights().equals((Object)this.getRights()) || channel.getResponsibleSecurityID() != null && this.getSecurityStationID() != null && !channel.getResponsibleSecurityID().equals(this.getSecurityStationID()) || channel.getResponsibleSecurityID() != this.getSecurityStationID()) {
                manager.updateChannelRights(this.channelIdentifier, this.getRights(), this.getSecurityStationID());
            }
        }
    }

    @Override
    public ModernPacket template() {
        return new EditChannelPacket(this.getId());
    }

    public UUID getChannelIdentifier() {
        return this.channelIdentifier;
    }

    public EditChannelPacket setChannelIdentifier(UUID channelIdentifier) {
        this.channelIdentifier = channelIdentifier;
        return this;
    }
}

