/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.util.Collections;
import java.util.List;
import logisticspipes.network.packetcontent.IPacketContent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public abstract class ModernPacket {
    private final int id;
    protected int leftRetries = 5;
    private boolean isChunkDataPacket;
    private boolean compressable;
    private int debugId = 0;
    private int dimension = 0;
    public List<IPacketContent<?>> content = Collections.emptyList();

    public ModernPacket(int id) {
        this.id = id;
    }

    public ModernPacket setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    public ModernPacket setDimension(World world) {
        this.dimension = world.field_73011_w.getDimension();
        return this;
    }

    public void readData(LPDataInput input) {
        this.dimension = input.readInt();
        this.content.forEach(it -> it.readData(input));
    }

    public abstract void processPacket(EntityPlayer var1);

    public void writeData(LPDataOutput output) {
        output.writeInt(this.dimension);
        this.content.forEach(it -> it.writeData(output));
    }

    public abstract ModernPacket template();

    public boolean retry() {
        return this.leftRetries-- > 0;
    }

    public int getId() {
        return this.id;
    }

    public boolean isChunkDataPacket() {
        return this.isChunkDataPacket;
    }

    public ModernPacket setChunkDataPacket(boolean isChunkDataPacket) {
        this.isChunkDataPacket = isChunkDataPacket;
        return this;
    }

    public boolean isCompressable() {
        return this.compressable;
    }

    public ModernPacket setCompressable(boolean compressable) {
        this.compressable = compressable;
        return this;
    }

    public int getDebugId() {
        return this.debugId;
    }

    public ModernPacket setDebugId(int debugId) {
        this.debugId = debugId;
        return this;
    }

    public int getDimension() {
        return this.dimension;
    }
}

