/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import logisticspipes.gui.hud.modules.HUDSimpleFilterModule;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.module.SimpleFilter;

@CCType(name="Terminus Module")
public class ModuleTerminus
extends LogisticsModule
implements SimpleFilter,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
ISimpleInventoryEventHandler,
IModuleInventoryReceive,
Gui {
    private final ItemIdentifierInventory _filterInventory = new ItemIdentifierInventory(9, "Terminated items", 1);
    private IHUDModuleRenderer HUD = new HUDSimpleFilterModule(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private SinkReply _sinkReply;

    public ModuleTerminus() {
        this._filterInventory.addListener(this);
    }

    public static String getName() {
        return "terminus";
    }

    @Override
    @CCCommand(description="Returns the FilterInventory of this Module")
    @Nonnull
    public IInventory getFilterInventory() {
        return this._filterInventory;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
    }

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.Terminus, 0, true, false, 2, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        if (this._filterInventory.containsUndamagedItem(item.getUndamaged()) && this._service.canUseEnergy(2)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Terminated: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._filterInventory)).setModulePos(this), this.localModeWatchers);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (MainProxy.isServer((IBlockAccess)this._world.getWorld())) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(inventory)).setModulePos(this), this.localModeWatchers);
        }
    }

    @Override
    public void handleInvContent(Collection<ItemIdentifierStack> list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
        Set<ItemIdentifier> filterItemids = this._filterInventory.getItemsAndCount().keySet();
        itemidCollection.addAll(filterItemids);
        filterItemids.stream().map(ItemIdentifier::getUndamaged).forEach(itemidCollection::add);
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return SimpleFilter.getPipeGuiProvider();
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return SimpleFilter.getInHandGuiProvider();
    }
}

