/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IQueueCCEvent;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.ISaveState;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.proxy.computers.objects.CCSinkResponder;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import network.rs485.logisticspipes.module.Gui;

@CCType(name="LogisticsModule")
public abstract class LogisticsModule
implements ISaveState,
ILPCCTypeHolder {
    private final Object[] ccTypeHolder = new Object[1];
    protected IWorldProvider _world;
    protected IPipeServiceProvider _service;
    protected ModulePositionType slot;
    protected int positionInt;

    public void registerHandler(IWorldProvider world, IPipeServiceProvider service) {
        this._world = world;
        this._service = service;
    }

    public void registerPosition(ModulePositionType slot, int positionInt) {
        this.slot = slot;
        this.positionInt = positionInt;
    }

    @Nonnull
    public BlockPos getBlockPos() {
        if (this.slot.isInWorld()) {
            return this._service.getPos();
        }
        if (LogisticsPipes.isDEBUG()) {
            throw new IllegalStateException("Module is not in world, but getBlockPos was called");
        }
        return BlockPos.field_177992_a;
    }

    public World getWorld() {
        return this._world.getWorld();
    }

    public ModulePositionType getSlot() {
        return this.slot;
    }

    public int getPositionInt() {
        return this.positionInt;
    }

    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        return null;
    }

    public abstract void tick();

    public abstract boolean hasGenericInterests();

    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
    }

    public abstract boolean interestedInAttachedInventory();

    public abstract boolean interestedInUndamagedID();

    public abstract boolean recievePassive();

    public boolean hasEffect() {
        return false;
    }

    public List<CCSinkResponder> queueCCSinkEvent(ItemIdentifierStack item) {
        return new ArrayList<CCSinkResponder>(0);
    }

    public void registerCCEventQueuer(IQueueCCEvent eventQueuer) {
    }

    @CCCommand(description="Returns true if the Pipe has a gui")
    public boolean hasGui() {
        return this instanceof Gui;
    }

    @Nonnull
    public LogisticsModule getModule() {
        return this;
    }

    @Nullable
    protected ISlotUpgradeManager getUpgradeManager() {
        if (this._service == null) {
            return null;
        }
        return this._service.getUpgradeManager(this.slot, this.positionInt);
    }

    public void clearCache() {
    }

    public String toString() {
        String at = "{service is null}";
        if (this._service != null) {
            at = Objects.toString(this._service.getPos());
        }
        String in = "{world is null}";
        if (this._world != null) {
            in = Objects.toString(this._world.getWorld());
        }
        return String.format("%s at %s in %s", this.getClass().getName(), at, in);
    }

    @Override
    public Object[] getTypeHolder() {
        return this.ccTypeHolder;
    }

    public static enum ModulePositionType {
        SLOT(true),
        IN_HAND(false),
        IN_PIPE(true);

        private final boolean inWorld;

        private ModulePositionType(boolean inWorld) {
            this.inWorld = inWorld;
        }

        public boolean isInWorld() {
            return this.inWorld;
        }
    }
}

