/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.interfaces.IItemAdvancedExistance;
import logisticspipes.items.LogisticsItem;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class LogisticsItemCard
extends LogisticsItem
implements IItemAdvancedExistance {
    public static final int FREQ_CARD = 0;
    public static final int SEC_CARD = 1;

    public LogisticsItemCard() {
        this.field_77787_bX = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!stack.func_77942_o()) {
            tooltip.add(StringUtils.translate("tooltip.logisticsItemCard"));
        } else {
            NBTTagCompound tag = Objects.requireNonNull(stack.func_77978_p());
            if (tag.func_74764_b("UUID")) {
                if (stack.func_77952_i() == 0) {
                    tooltip.add("Freq. Card");
                } else if (stack.func_77952_i() == 1) {
                    tooltip.add("Sec. Card");
                }
                if (Keyboard.isKeyDown((int)42)) {
                    tooltip.add("Id: " + tag.func_74779_i("UUID"));
                    if (stack.func_77952_i() == 1) {
                        UUID id = UUID.fromString(tag.func_74779_i("UUID"));
                        tooltip.add("Authorization: " + (SimpleServiceLocator.securityStationManager.isAuthorized(id) ? "Authorized" : "Deauthorized"));
                    }
                }
            }
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public int func_77639_j() {
        return 64;
    }

    @Override
    public boolean canExistInNormalInventory(@Nonnull ItemStack stack) {
        return true;
    }

    @Override
    public boolean canExistInWorld(@Nonnull ItemStack stack) {
        return stack.func_77952_i() != 1;
    }
}

