/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.datafixer;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MissingMappingHandler {
    private Map<String, String> itemIDMap = ImmutableMap.builder().put((Object)"item.pipeitemsbasiclogistics", (Object)"pipe_basic").put((Object)"item.pipeitemsbasictransport", (Object)"pipe_transport_basic").put((Object)"item.pipelogisticschassimk1", (Object)"pipe_chassis_mk1").put((Object)"item.pipelogisticschassimk2", (Object)"pipe_chassis_mk2").put((Object)"item.pipelogisticschassimk3", (Object)"pipe_chassis_mk3").put((Object)"item.pipelogisticschassimk4", (Object)"pipe_chassis_mk4").put((Object)"item.pipelogisticschassimk5", (Object)"pipe_chassis_mk5").put((Object)"item.pipeitemssupplierlogistics", (Object)"pipe_supplier").put((Object)"item.pipeitemscraftinglogistics", (Object)"pipe_crafting").put((Object)"item.pipeitemscraftinglogisticsmk2", (Object)"pipe_crafting_mk2").put((Object)"item.pipeitemscraftinglogisticsmk3", (Object)"pipe_crafting_mk3").put((Object)"item.pipeitemsfirewall", (Object)"pipe_firewall").put((Object)"item.pipeitemsproviderlogisticsmk2", (Object)"pipe_provider_mk2").put((Object)"item.pipeitemsrequestlogistics", (Object)"pipe_request").put((Object)"item.pipeitemsremoteordererlogistics", (Object)"pipe_remote_orderer").put((Object)"item.pipeitemssatellitelogistics", (Object)"pipe_satellite").put((Object)"item.pipeblockrequesttable", (Object)"pipe_request_table").put((Object)"item.pipeitemsproviderlogistics", (Object)"pipe_provider").put((Object)"item.pipeitemsinvsysconnector", (Object)"pipe_inventory_system_connector").put((Object)"item.pipeitemsrequestlogisticsmk2", (Object)"pipe_request_mk2").put((Object)"item.pipeitemssystemdestinationlogistics", (Object)"pipe_system_destination").put((Object)"item.pipeitemssystementrancelogistics", (Object)"pipe_system_entrance").put((Object)"item.pipefluidbasic", (Object)"pipe_fluid_basic").put((Object)"item.pipefluidprovider", (Object)"pipe_fluid_provider").put((Object)"item.pipefluidinsertion", (Object)"pipe_fluid_insertion").put((Object)"item.pipeitemsfluidsupplier", (Object)"pipe_fluid_supplier").put((Object)"item.pipefluidsuppliermk2", (Object)"pipe_fluid_supplier_mk2").put((Object)"item.pipefluidrequestlogistics", (Object)"pipe_fluid_request").put((Object)"item.pipefluidextractor", (Object)"pipe_fluid_extractor").put((Object)"item.pipefluidsatellite", (Object)"pipe_fluid_satellite").put((Object)"item.hstubeline", (Object)"pipe_hs_line").put((Object)"item.hstubegain", (Object)"pipe_hs_gain").put((Object)"item.hstubescurve", (Object)"pipe_hs_s_curve").put((Object)"item.hstubespeedup", (Object)"pipe_hs_speedup").put((Object)"item.hstubecurve", (Object)"pipe_hs_curve").put((Object)"moduleblank", (Object)"module_blank").put((Object)"itemmodule.moduleitemsink", (Object)"module_item_sink").put((Object)"itemmodule.modulemodbaseditemsink", (Object)"module_item_sink_mod").put((Object)"itemmodule.moduleextractor", (Object)"module_extractor").put((Object)"itemmodule.moduleextractormk2", (Object)"module_extractor_mk2").put((Object)"itemmodule.moduleextractormk3", (Object)"module_extractor_mk3").put((Object)"itemmodule.modulecrafter", (Object)"module_crafter").put((Object)"itemmodule.modulecraftermk2", (Object)"module_crafter_mk2").put((Object)"itemmodule.modulecraftermk3", (Object)"module_crafter_mk3").put((Object)"itemmodule.modulepassivesupplier", (Object)"module_passive_supplier").put((Object)"itemmodule.modulepolymorphicitemsink", (Object)"module_item_sink_polymorphic").put((Object)"itemmodule.moduleadvancedextractor", (Object)"module_extractor_advanced").put((Object)"itemmodule.moduleadvancedextractormk2", (Object)"module_extractor_advanced_mk2").put((Object)"itemmodule.moduleadvancedextractormk3", (Object)"module_extractor_advanced_mk3").put((Object)"itemmodule.moduleccbasedquicksort", (Object)"module_quick_sort_cc").put((Object)"itemmodule.moduleenchantmentsink", (Object)"module_enchantment_sink").put((Object)"itemmodule.moduleenchantmentsinkmk2", (Object)"module_enchantment_sink_mk2").put((Object)"itemmodule.modulequicksort", (Object)"module_quick_sort").put((Object)"itemmodule.moduleprovider", (Object)"module_provider").put((Object)"itemmodule.moduleprovidermk2", (Object)"module_provider_mk2").put((Object)"itemmodule.moduleoredictitemsink", (Object)"module_item_sink_oredict").put((Object)"itemmodule.modulecreativetabbaseditemsink", (Object)"module_item_sink_creativetab").put((Object)"itemmodule.moduleterminus", (Object)"module_terminus").put((Object)"itemmodule.moduleactivesupplier", (Object)"module_active_supplier").put((Object)"itemmodule.moduleccbaseditemsink", (Object)"module_item_sink_cc").put((Object)"itemmodule.rfpowersupplierupgrade", (Object)"upgrade_power_supplier_rf").put((Object)"itemmodule.bcpowersupplierupgrade", (Object)"upgrade_power_supplier_mj").put((Object)"itemmodule.ic2lvpowersupplierupgrade", (Object)"upgrade_power_supplier_eu_lv").put((Object)"itemmodule.ic2mvpowersupplierupgrade", (Object)"upgrade_power_supplier_eu_mv").put((Object)"itemmodule.ic2hvpowersupplierupgrade", (Object)"upgrade_power_supplier_eu_hv").put((Object)"itemmodule.ic2evpowersupplierupgrade", (Object)"upgrade_power_supplier_eu_ev").put((Object)"itemmodule.fluidcraftingupgrade", (Object)"upgrade_fluid_crafting").put((Object)"itemmodule.logiccontrollerupgrade", (Object)"upgrade_logic_controller").put((Object)"itemmodule.connectionupgradeconfig", (Object)"upgrade_disconnection").put((Object)"itemmodule.sneakyupgradeconfig", (Object)"upgrade_sneaky").put((Object)"itemmodule.ccremotecontrolupgrade", (Object)"upgrade_cc_remote_control").put((Object)"itemmodule.opaqueupgrade", (Object)"upgrade_opaque").put((Object)"itemmodule.powertransportationupgrade", (Object)"upgrade_power_transportation").put((Object)"itemmodule.combinedsneakyupgrade", (Object)"upgrade_sneaky_combination").put((Object)"itemmodule.fuzzyupgrade", (Object)"upgrade_fuzzy").put((Object)"itemmodule.advancedsatelliteupgrade", (Object)"upgrade_satellite_advanced").put((Object)"itemmodule.craftingcleanupupgrade", (Object)"upgrade_crafting_cleanup").put((Object)"itemmodule.craftingmonitoringupgrade", (Object)"upgrade_crafting_monitoring").put((Object)"itemmodule.upgrademoduleupgrade", (Object)"upgrade_module_upgrade").put((Object)"itemmodule.speedupgrade", (Object)"upgrade_speed").put((Object)"itemmodule.patternupgrade", (Object)"upgrade_pattern").put((Object)"itemmodule.craftingbyproductupgrade", (Object)"upgrade_crafting_byproduct").put((Object)"logisticsfluidcontainer", (Object)"fluid_container").put((Object)"logisticsprogrammer", (Object)"logistics_programmer").put((Object)"remoteordereritem", (Object)"remote_orderer").put((Object)"logisticschips.0", (Object)"chip_basic").put((Object)"logisticschips.1", (Object)"chip_basic_raw").put((Object)"logisticschips.2", (Object)"chip_advanced").put((Object)"logisticschips.3", (Object)"chip_advanced_raw").put((Object)"logisticschips.4", (Object)"chip_fpga").put((Object)"logisticschips.5", (Object)"chip_fpga_raw").put((Object)"brokenitem", (Object)"broken_item").put((Object)"logisticsparts", (Object)"parts").put((Object)"pipecontroller", (Object)"pipe_controller").put((Object)"pipemanager", (Object)"pipe_manager").put((Object)"logisticshudglasses", (Object)"hud_glasses").put((Object)"logisticsitemcard", (Object)"item_card").put((Object)"itempipesigncreator", (Object)"sign_creator").put((Object)"itemdisk", (Object)"disk").build();
    private Map<String, String> blockIDMap = ImmutableMap.builder().put((Object)"tile.logisticssolidblock", (Object)"solid_block").put((Object)"tile.logisticsblockgenericsubmultiblock", (Object)"sub_multiblock").put((Object)"tile.logisticsblockgenericpipe", (Object)"pipe").build();
    private List<String> ignoreItems = Arrays.asList("solid_block", "tile.logisticssolidblock");

    @SubscribeEvent
    public void onMissingBlocks(RegistryEvent.MissingMappings<Block> e) {
        for (RegistryEvent.MissingMappings.Mapping m : e.getMappings()) {
            Block value;
            String entry = this.blockIDMap.get(m.key.func_110623_a());
            if (entry == null || (value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("logisticspipes", entry))) == null) continue;
            m.remap((IForgeRegistryEntry)value);
        }
    }

    @SubscribeEvent
    public void onMissingItems(RegistryEvent.MissingMappings<Item> e) {
        for (RegistryEvent.MissingMappings.Mapping m : e.getMappings()) {
            Item value;
            String old = m.key.func_110623_a();
            if (this.ignoreItems.contains(old)) {
                m.ignore();
                continue;
            }
            String entry = this.itemIDMap.get(old);
            if (entry == null || (value = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("logisticspipes", entry))) == null) continue;
            m.remap((IForgeRegistryEntry)value);
        }
    }
}

