/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm.wrapper;

import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.asm.wrapper.WrapperState;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.string.ChatColor;

public abstract class AbstractWrapper {
    protected WrapperState state = WrapperState.Enabled;
    private Throwable reason;
    private String modId;
    private List<Class<?>> wrapperInterfaces;

    public void handleException(Throwable e) {
        if (!this.isEnabled()) {
            if (LogisticsPipes.isDEBUG()) {
                e.printStackTrace();
            }
            return;
        }
        if (LogisticsPipes.isDEBUG()) {
            throw e;
        }
        e.printStackTrace();
        this.state = WrapperState.Exception;
        this.reason = e;
        String message = "Disabled " + this.getName() + this.getTypeName() + (this.modId != null ? " for Mod: " + this.modId : "") + ". Cause was an Exception";
        LogisticsPipes.log.fatal(message);
        MainProxy.proxy.sendBroadCast((Object)((Object)ChatColor.RED) + message);
    }

    public void reEnable() {
        if (this.state != WrapperState.Exception) {
            return;
        }
        this.state = WrapperState.Enabled;
        this.reason = null;
    }

    protected boolean isEnabled() {
        return this.state == WrapperState.Enabled;
    }

    protected boolean canTryAnyway() {
        return this.state != WrapperState.ModMissing;
    }

    public abstract String getName();

    public abstract String getTypeName();

    public WrapperState getState() {
        return this.state;
    }

    AbstractWrapper setState(WrapperState state) {
        this.state = state;
        return this;
    }

    public Throwable getReason() {
        return this.reason;
    }

    AbstractWrapper setReason(Throwable reason) {
        this.reason = reason;
        return this;
    }

    public String getModId() {
        return this.modId;
    }

    AbstractWrapper setModId(String modId) {
        this.modId = modId;
        return this;
    }

    public List<Class<?>> getWrapperInterfaces() {
        return this.wrapperInterfaces;
    }

    AbstractWrapper setWrapperInterfaces(List<Class<?>> wrapperInterfaces) {
        this.wrapperInterfaces = wrapperInterfaces;
        return this;
    }
}

